/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.io.File;
import java.io.IOException;
import org.hyperic.hq.product.ClientPluginDeployer;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.util.xmlparser.XmlTagException;
import org.hyperic.util.xmlparser.XmlTextHandler;

public class EmbedTag
extends BaseTag
implements XmlTextHandler {
    private static final String[] REQUIRED_ATTRS = new String[]{"name"};
    private static final String[] OPTIONAL_ATTRS = new String[]{"type"};
    private String text;

    EmbedTag(BaseTag parent) {
        super(parent);
    }

    public String getName() {
        return "embed";
    }

    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    public String[] getRequiredAttributes() {
        return REQUIRED_ATTRS;
    }

    public void handleText(String text) {
        this.text = text.trim();
    }

    protected String getType() {
        String type = this.getAttribute("type");
        if (type == null) {
            return this.getName();
        }
        return type;
    }

    void write() throws XmlTagException {
        String name = this.getAttribute("name");
        String pdkWork = ProductPluginManager.getPdkWorkDir();
        if (pdkWork == null) {
            return;
        }
        String pluginName = this.data.getPluginName();
        if (pluginName == null) {
            String msg = "Unable to determine plugin name for: " + this.data.file;
            throw new XmlTagException(msg);
        }
        ClientPluginDeployer deployer = new ClientPluginDeployer(pdkWork, pluginName);
        String type = this.getType();
        if (!deployer.isDeployableType(type)) {
            String msg = "Invalid " + this.getName() + " type=" + type;
            throw new XmlTagException(msg);
        }
        File file = deployer.getFile(type, name);
        if (file == null) {
            return;
        }
        if (this.data.getProperty(name) == null) {
            this.data.setProperty(name, file.getPath());
        }
        if (deployer.upToDate(new File(this.data.file), file)) {
            return;
        }
        try {
            deployer.write(this.text, file);
        }
        catch (IOException e) {
            throw new XmlTagException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endTag() throws XmlTagException {
        super.endTag();
        try {
            this.write();
        }
        finally {
            this.text = null;
        }
    }
}

