/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.StringMatcher;
import org.hyperic.hq.product.Win32EventLogNotification;
import org.hyperic.sigar.win32.EventLogRecord;
import org.hyperic.util.config.ConfigResponse;

public class Win32EventLogTrackPlugin
extends LogTrackPlugin {
    private static final Log log = LogFactory.getLog((String)"Win32EventLogTrackPlugin");
    private Win32EventLogNotification notifier;

    public Win32EventLogNotification getEventLogNotification() {
        SourceFilterNotification notifier = new SourceFilterNotification(this);
        String source = this.getTypeProperty("EVENT_LOG_SOURCE_FILTER");
        if (source == null) {
            source = this.getConfig().getValue("service_name");
        }
        if (source == null) {
            source = ".*";
        }
        notifier.setSource(source);
        if (log.isDebugEnabled()) {
            String msg = "Created filter '" + notifier.source + "' for type=" + this.getTypeInfo().getName();
            log.debug((Object)msg);
        }
        return notifier;
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        try {
            this.notifier = this.getEventLogNotification();
        }
        catch (IllegalArgumentException e) {
            String msg = "getEventLogNotification error: " + e.getMessage();
            throw new PluginException(msg);
        }
        this.getManager().addEventLogNotification(this.notifier);
    }

    public void shutdown() throws PluginException {
        if (this.notifier != null) {
            this.getManager().removeEventLogNotification(this.notifier);
        }
        super.shutdown();
    }

    private class SourceFilterNotification
    extends Win32EventLogNotification {
        private StringMatcher source;

        private SourceFilterNotification(LogTrackPlugin plugin) {
            super(plugin);
        }

        private void setSource(String source) {
            this.source = new StringMatcher();
            this.source.setIncludes(source);
        }

        public boolean matches(EventLogRecord record) {
            return this.source.matches(record.getSource());
        }
    }
}

