/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.Set;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ServiceType;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUpdater {
    private void addControlActions(ProductPlugin productPlugin, ServiceType serviceType) {
        productPlugin.getPluginData().removeControlActions(serviceType.getInfo().getName());
        productPlugin.getPluginData().addControlActions(serviceType.getInfo().getName(), new ArrayList(serviceType.getControlActions()));
    }

    private void addCustomProperties(ProductPlugin productPlugin, ServiceType serviceType) {
        productPlugin.getPluginData().removeCustomPropertiesSchema(serviceType.getInfo().getName());
        if (serviceType.getCustomProperties() != null) {
            productPlugin.getPluginData().addCustomPropertiesSchema(serviceType.getInfo().getName(), serviceType.getCustomProperties());
        }
    }

    private void addMetrics(ProductPlugin productPlugin, ServiceType serviceType) {
        productPlugin.getPluginData().removeMetrics(serviceType.getInfo().getName());
        Set measurementInfos = serviceType.getMeasurements().getMeasurements();
        for (MeasurementInfo measurement : measurementInfos) {
            productPlugin.getPluginData().addMetric(serviceType.getInfo().getName(), measurement);
        }
    }

    private void addPlugins(ProductPlugin productPlugin, ServiceType serviceType) {
        productPlugin.getPluginData().removePlugins(serviceType.getInfo().getName());
        ConfigResponse pluginClasses = serviceType.getPluginClasses();
        for (String pluginName : pluginClasses.getKeys()) {
            productPlugin.getPluginData().addPlugin(pluginName, serviceType.getInfo().getName(), pluginClasses.getValue(pluginName));
        }
        productPlugin.getPluginData().addServiceInventoryPlugin(serviceType.getInfo().getServerName(), serviceType.getInfo().getName(), null);
    }

    private void addProperties(ServiceType serviceType) {
        ConfigResponse properties = serviceType.getProperties();
        for (String propertyName : properties.getKeys()) {
            PluginData.getGlobalProperties().put(propertyName, properties.getValue(propertyName));
        }
    }

    private void updatePluginData(ProductPlugin productPlugin, ServiceType serviceType) {
        this.addProperties(serviceType);
        this.addPlugins(productPlugin, serviceType);
        this.addControlActions(productPlugin, serviceType);
        this.addCustomProperties(productPlugin, serviceType);
        boolean isServer = productPlugin.getManager().getRegisterTypes();
        if (isServer) {
            this.addMetrics(productPlugin, serviceType);
        }
    }

    public void updateServiceTypes(ProductPlugin productPlugin, Set<ServiceType> serviceTypes) throws PluginException {
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>(serviceTypes.size());
        for (ServiceType serviceType : serviceTypes) {
            this.updatePluginData(productPlugin, serviceType);
            typeInfos.add(serviceType.getInfo());
        }
        TypeInfo[] typeInfosArray = typeInfos.toArray(new TypeInfo[typeInfos.size()]);
        productPlugin.getPluginData().removeTypes(typeInfosArray);
        productPlugin.getPluginData().addTypes(typeInfosArray);
        productPlugin.getManager().removePluginTypes(typeInfos);
        productPlugin.getManager().addPluginTypes(typeInfosArray, productPlugin);
    }
}

