/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.cm.filemonitor.IChangeListener;
import org.hyperic.cm.filemonitor.IFileMonitor;
import org.hyperic.cm.filemonitor.data.EventActionsEnum;
import org.hyperic.cm.filemonitor.data.EventMessage;
import org.hyperic.hq.product.ConfigFileTrackPlugin;
import org.hyperic.hq.product.IMonitorConfig;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public class FileChangeTrackPlugin
extends ConfigFileTrackPlugin {
    private Collection<String> monitoredDirs = new ArrayList<String>();
    protected static Log log = LogFactory.getLog((String)FileChangeTrackPlugin.class.getName());
    private EventHandler eventHandler = null;

    protected String getDefaultConfigFile(TypeInfo info, ConfigResponse config) {
        List<IMonitorConfig> configs = this.data.getMonitoredConfigs();
        if (configs == null || configs.size() <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (IMonitorConfig monitoredConf : configs) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(monitoredConf.toString());
        }
        return sb.toString();
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        return super.getConfigSchema(info, config);
    }

    public void configure(ConfigResponse config) throws PluginException {
        log.info((Object)"FileChangeTrackPlugin plugin configure()");
        this.config = config;
        PluginData data = this.getPluginData();
        List<IMonitorConfig> configs = data.getMonitoredConfigs();
        if (configs == null || configs.size() <= 0) {
            return;
        }
        String installpath = config.getValue("installpath");
        StringBuffer sb = new StringBuffer();
        sb.append("<templates><monitored>");
        for (IMonitorConfig monitoredConf : configs) {
            sb.append(monitoredConf.dumpXML());
        }
        sb.append("</monitored></templates>");
        IFileMonitor monitor = this.getManager().getFileMonitor();
        if (this.eventHandler == null) {
            this.eventHandler = new EventHandler();
        }
        this.monitoredDirs = monitor.addMonitoredDirs(installpath, sb.toString(), (IChangeListener)this.eventHandler);
    }

    public void shutdown() throws PluginException {
        IFileMonitor monitor = this.getManager().getFileMonitor();
        if (monitor != null && this.monitoredDirs != null && this.monitoredDirs.size() > 0) {
            monitor.removeMonitoredDirs(this.monitoredDirs);
            this.monitoredDirs.clear();
        }
        super.shutdown();
    }

    protected class EventHandler
    implements IChangeListener {
        protected EventHandler() {
        }

        public void onChange(EventMessage eventMsg) {
            String details;
            String pathToCheck;
            String string = pathToCheck = EventActionsEnum.RENAME.equals((Object)eventMsg.getType()) ? eventMsg.getOldFullPath() : eventMsg.getFullPath();
            if (pathToCheck == null) {
                log.error((Object)"Unexpected null value path");
                return;
            }
            switch (eventMsg.getType()) {
                case CREATE: 
                case DELETE: {
                    if (eventMsg.getDiff() != null && eventMsg.getDiff().length() > 0) {
                        details = eventMsg.getDiff();
                        break;
                    }
                    details = eventMsg.getFullPath();
                    break;
                }
                case RENAME: {
                    details = eventMsg.getFullPath() + ";" + eventMsg.getOldFullPath();
                    break;
                }
                case MODIFY: {
                    details = eventMsg.getDiff();
                    break;
                }
                default: {
                    details = "";
                }
            }
            TrackEvent event = new TrackEvent(FileChangeTrackPlugin.this.getName(), System.currentTimeMillis(), 6, eventMsg.getType().protocolValue(), details);
            FileChangeTrackPlugin.this.getManager().reportEvent(event);
        }
    }
}

