/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.db2;

import org.hyperic.hq.plugin.db2.DB2MeasurementPlugin;
import org.hyperic.hq.plugin.db2.DB2ServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.TypeBuilder;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.SchemaBuilder;

public class DB2ProductPlugin
extends ProductPlugin {
    public static final String NAME = "db2";
    static final String SERVER_NAME = "DB2";
    static final String VERSION_7 = "7.x";
    static final String VERSION_8 = "8.x";
    static final String VERSION_9 = "9.x";
    static final String DATABASE = "Database";
    static final String TABLE = "Table";
    static final String TABLESPACE = "Tablespace";
    static final String FULL_SERVER_NAME_V7 = TypeBuilder.composeServerTypeName((String)"DB2", (String)"7.x");
    static final String FULL_DATABASE_NAME_V7 = TypeBuilder.composeServiceTypeName((String)FULL_SERVER_NAME_V7, (String)"Database");
    static final String FULL_TABLE_NAME_V7 = TypeBuilder.composeServiceTypeName((String)FULL_SERVER_NAME_V7, (String)"Table");
    static final String FULL_TABLESPACE_NAME_V7 = TypeBuilder.composeServiceTypeName((String)FULL_SERVER_NAME_V7, (String)"Tablespace");
    static final String FULL_SERVER_NAME_V8 = TypeBuilder.composeServerTypeName((String)"DB2", (String)"8.x");
    static final String FULL_DATABASE_NAME_V8 = TypeBuilder.composeServiceTypeName((String)FULL_SERVER_NAME_V8, (String)"Database");
    static final String FULL_TABLE_NAME_V8 = TypeBuilder.composeServiceTypeName((String)FULL_SERVER_NAME_V8, (String)"Table");
    static final String FULL_TABLESPACE_NAME_V8 = TypeBuilder.composeServiceTypeName((String)FULL_SERVER_NAME_V8, (String)"Tablespace");
    static final String FULL_SERVER_NAME_V9 = TypeBuilder.composeServerTypeName((String)"DB2", (String)"9.x");
    static final String FULL_DATABASE_NAME_V9 = TypeBuilder.composeServiceTypeName((String)FULL_SERVER_NAME_V9, (String)"Database");
    static final String FULL_TABLE_NAME_V9 = TypeBuilder.composeServiceTypeName((String)FULL_SERVER_NAME_V9, (String)"Table");
    static final String FULL_TABLESPACE_NAME_V9 = TypeBuilder.composeServiceTypeName((String)FULL_SERVER_NAME_V9, (String)"Tablespace");
    static final String[] SERVICES = new String[]{"Database", "Table", "Tablespace"};
    static final String PROP_NODENAME = "nodename";
    static final String PROP_USER = "user";
    static final String PROP_PASSWORD = "password";
    static final String PROP_DATABASE = "database";
    static final String PROP_TABLE = "table";
    static final String PROP_TABLESPACE = "tablespace";
    static final String PROP_MON_ENABLE = "enableMon";

    public DB2ProductPlugin() {
        this.setName(NAME);
    }

    public GenericPlugin getPlugin(String type, TypeInfo entity) {
        if (type.equals("measurement")) {
            return new DB2MeasurementPlugin();
        }
        if (type.equals("autoinventory") && entity.getType() == 2) {
            return new DB2ServerDetector(entity.getVersion());
        }
        return null;
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        SchemaBuilder schema = new SchemaBuilder(config);
        switch (info.getType()) {
            case 2: {
                ConfigOption opt = schema.add(PROP_NODENAME, "DB2 Node Name", "");
                opt.setOptional(true);
                opt = schema.add(PROP_USER, "Username", "");
                opt.setOptional(true);
                opt = schema.addSecret(PROP_PASSWORD, "Password");
                opt.setOptional(true);
                schema.add(PROP_MON_ENABLE, "Enable monitoring switches", false);
                break;
            }
            case 3: {
                schema.add(PROP_DATABASE, "Database Alias", "SAMPLE");
                if (info.isService(TABLE)) {
                    schema.add(PROP_TABLE, "Table Name", "STAFF");
                    break;
                }
                if (!info.isService(TABLESPACE)) break;
                schema.add(PROP_TABLESPACE, "Tablespace Name", "SYSCATSPACE");
            }
        }
        return schema.getSchema();
    }

    public TypeInfo[] getTypes() {
        TypeBuilder types = new TypeBuilder(SERVER_NAME, SERVER_NAME);
        ServerTypeInfo server = types.addServer(VERSION_7);
        types.addServices(server, SERVICES);
        server = types.addServer(VERSION_8);
        types.addServices(server, SERVICES);
        server = types.addServer(VERSION_9);
        types.addServices(server, SERVICES);
        return types.getTypes();
    }
}

