/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss;

import org.hyperic.hq.plugin.jboss.JBossServiceControlPlugin;
import org.hyperic.hq.plugin.jboss.JBossUtil;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;

public class JBossStateServiceControlPlugin
extends JBossServiceControlPlugin {
    protected boolean isRunning() {
        Object value;
        Metric metric = this.getConfiguredMetric();
        try {
            value = JBossUtil.getRemoteMBeanValue(metric);
            if (value == null) {
                return false;
            }
        }
        catch (Exception e) {
            this.getLog().debug((Object)("isRunning: " + e.getMessage()), (Throwable)e);
            return false;
        }
        if (metric.getAttributeName().equals("StateString")) {
            return value.equals("Started");
        }
        return true;
    }

    public void doAction(String action, String[] args) throws PluginException {
        if (args.length == 0) {
            if (action.equals("start")) {
                this.start();
                return;
            }
            if (action.equals("stop")) {
                this.stop();
                return;
            }
            if (action.equals("restart")) {
                this.restart();
                return;
            }
        }
        super.doAction(action, args);
    }

    private void handleResult(int result, String stateWanted) {
        if (result != 0) {
            this.setResult(result);
            return;
        }
        String state = this.waitForState(stateWanted);
        if (!state.equals(stateWanted)) {
            this.setResult(-1);
            this.setMessage("service still in state " + state);
        } else {
            this.setResult(result);
        }
    }

    void start() {
        if (this.isRunning()) {
            this.setResult(-1);
            this.setMessage("Service already started");
            return;
        }
        this.invokeMethod("start");
        this.handleResult(this.getResult(), "started");
    }

    void stop() {
        if (!this.isRunning()) {
            this.setResult(-1);
            this.setMessage("Service already stopped");
            return;
        }
        this.invokeMethod("stop");
        this.handleResult(this.getResult(), "stopped");
    }

    private void restart() {
        boolean hadToStop = false;
        if (this.isRunning()) {
            hadToStop = true;
            this.stop();
        }
        if (!hadToStop || this.getResult() == 0) {
            this.start();
        }
    }
}

