/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hyperic.hq.plugin.jboss.JBossMeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class JBoss5MeasurementPlugin
extends JBossMeasurementPlugin {
    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, PluginException {
        MetricValue res;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"*******************");
            this.getLog().debug((Object)("** MT " + metric));
            this.getLog().debug((Object)("** DN " + metric.getDomainName()));
            this.getLog().debug((Object)("** OP " + metric.getObjectProperties()));
            this.getLog().debug((Object)("** ON " + metric.getObjectName()));
            this.getLog().debug((Object)("** AT " + metric.getAttributeName()));
            this.getLog().debug((Object)("** PR " + metric.getProperties()));
            this.getLog().debug((Object)"*******************");
        }
        try {
            res = super.getValue(metric);
        }
        catch (Exception ex) {
            this.getLog().debug((Object)ex.getMessage());
            if ("Availability".equals(metric.getAttributeName())) {
                res = new MetricValue(0.0);
            }
            throw new MetricNotFoundException(ex.getMessage(), (Throwable)ex);
        }
        if ("topic".equalsIgnoreCase(metric.getObjectProperties().getProperty("service"))) {
            if (res.getValue() < 0.0) {
                res.setValue(0.0);
            } else {
                res.setValue(1.0);
            }
        } else if (metric.getAttributeName().equalsIgnoreCase("state")) {
            switch ((int)res.getValue()) {
                case 8: {
                    res.setValue(1.0);
                    break;
                }
                default: {
                    res.setValue(0.0);
                    break;
                }
            }
        } else if (metric.getAttributeName().equalsIgnoreCase("AvailableCount") && res.getValue() < 0.0) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("[getValue] AvailableCount='" + res.getValue() + "' => '0'"));
            }
            res.setValue(0.0);
        }
        if (this.getLog().isDebugEnabled() && "Availability".equals(metric.getAttributeName())) {
            this.getLog().debug((Object)"*******************");
            this.getLog().debug((Object)("res = '" + res + "'"));
            this.getLog().debug((Object)"*******************");
        }
        return res;
    }

    public String translate(String template, ConfigResponse config) {
        return super.translate(JBoss5MeasurementPlugin.translateMetic(template, config), config);
    }

    public static String translateMetic(String template, ConfigResponse config) {
        Pattern p = Pattern.compile("([:|,])([^=]*)=_(%([^%]*)%)([:|,])");
        Matcher m = p.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            if (config.getValue(m.group(4)) != null) {
                m.appendReplacement(sb, m.group(1) + m.group(2) + "=" + m.group(3) + m.group(5));
                continue;
            }
            m.appendReplacement(sb, m.group(1));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

