/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.remote.JMXConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerExtValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.appdef.shared.AIServiceTypeValue;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.plugin.weblogic.WeblogicAuth;
import org.hyperic.hq.plugin.weblogic.WeblogicDetector;
import org.hyperic.hq.plugin.weblogic.WeblogicProductPlugin;
import org.hyperic.hq.plugin.weblogic.WeblogicUtil;
import org.hyperic.hq.plugin.weblogic.jmx.ApplicationQuery;
import org.hyperic.hq.plugin.weblogic.jmx.BaseServerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.DynamicServiceQuery;
import org.hyperic.hq.plugin.weblogic.jmx.NodeManagerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.ServerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.ServiceQuery;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicDiscover;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicDiscoverException;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicQuery;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginUpdater;
import org.hyperic.hq.product.RuntimeDiscoverer;
import org.hyperic.hq.product.RuntimeResourceReport;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceType;
import org.hyperic.hq.product.jmx.ServiceTypeFactory;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;

public class WeblogicRuntimeDiscoverer
implements RuntimeDiscoverer,
PrivilegedAction {
    private static final Double DYNAMIC_SVC_SUPPORTED_WEBLOGIC_VERSION = new Double(9.1);
    private static final boolean useJAAS = WeblogicProductPlugin.useJAAS();
    private static final String PROP_FQDN = "weblogic.discover.fqdn";
    private static Log log = LogFactory.getLog(WeblogicRuntimeDiscoverer.class);
    private int serverId;
    private Properties props;
    private AIPlatformValue aiplatform;
    private ConfigResponse config;
    private String targetFqdn = null;
    private WeblogicDetector plugin;
    private String version;
    private ServiceTypeFactory serviceTypeFactory = new ServiceTypeFactory();
    private PluginUpdater pluginUpdater = new PluginUpdater();

    public WeblogicRuntimeDiscoverer(WeblogicDetector plugin) {
        this.plugin = plugin;
        this.version = plugin.getTypeInfo().getVersion();
        this.props = plugin.getManager().getProperties();
        this.targetFqdn = this.props.getProperty(PROP_FQDN);
    }

    public WeblogicDetector getPlugin() {
        return this.plugin;
    }

    public String getPluginVersion() {
        return this.version;
    }

    public RuntimeResourceReport discoverResources(int serverId, AIPlatformValue aiplatform, ConfigResponse config) throws PluginException {
        if (useJAAS) {
            return this.discoverAs(serverId, aiplatform, config);
        }
        try {
            return this.discover(serverId, aiplatform, config);
        }
        catch (SecurityException e) {
            String msg = "SecurityException: " + e.getMessage();
            throw new PluginException(msg, (Throwable)e);
        }
    }

    private RuntimeResourceReport discoverAs(int serverId, AIPlatformValue aiplatform, ConfigResponse config) throws PluginException {
        Object obj;
        WeblogicAuth auth = WeblogicAuth.getInstance(config.toProperties());
        this.serverId = serverId;
        this.aiplatform = aiplatform;
        this.config = config;
        try {
            obj = auth.runAs(this);
        }
        catch (SecurityException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        if (obj instanceof RuntimeResourceReport) {
            return (RuntimeResourceReport)obj;
        }
        if (obj instanceof PluginException) {
            throw (PluginException)((Object)obj);
        }
        if (obj instanceof Exception) {
            Exception e = (Exception)obj;
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        throw new IllegalArgumentException();
    }

    public Object run() {
        try {
            return this.discover(this.serverId, this.aiplatform, this.config);
        }
        catch (Exception e) {
            return e;
        }
    }

    private RuntimeResourceReport discover(int serverId, AIPlatformValue aiplatform, ConfigResponse config) throws PluginException {
        String installpath = config.getValue("installpath");
        this.aiplatform = aiplatform;
        log.debug((Object)("discover using: " + config));
        String domainName = config.getValue("domain");
        String serverName = config.getValue("server");
        RuntimeResourceReport rrr = new RuntimeResourceReport(serverId);
        Properties props = config.toProperties();
        WeblogicDiscover discover = new WeblogicDiscover(this.version, props);
        try {
            MBeanServer mServer = discover.getMBeanServer();
            discover.init(mServer);
            NodeManagerQuery nodemgrQuery = new NodeManagerQuery();
            ServerQuery serverQuery = new ServerQuery();
            serverQuery.setDiscover(discover);
            ArrayList servers = new ArrayList();
            discover.find(mServer, serverQuery, servers);
            WeblogicQuery[] serviceQueries = discover.getServiceQueries();
            serverQuery.sort(servers);
            String adminVersion = null;
            for (int i = 0; i < servers.size(); ++i) {
                AIPlatformValue aPlatform;
                serverQuery = (ServerQuery)servers.get(i);
                if (!serverQuery.isRunning()) continue;
                if (serverQuery.isAdmin()) {
                    adminVersion = serverQuery.getVersion();
                } else if (serverQuery.getVersion() == null) {
                    serverQuery.setVersion(adminVersion);
                }
                AIServerExtValue aServer = this.generateServer(serverQuery);
                if (serverQuery.getName().equals(serverName) && serverQuery.getDiscover().getDomain().equals(domainName)) {
                    aServer.setId(new Integer(serverId));
                    aServer.setPlaceholder(true);
                    if (installpath != null) {
                        aServer.setInstallPath(installpath);
                    }
                    aiplatform.addAIServerValue((AIServerValue)aServer);
                    rrr.addAIPlatform(aiplatform);
                } else {
                    aPlatform = this.generatePlatform(serverQuery);
                    aPlatform.addAIServerValue((AIServerValue)aServer);
                    rrr.addAIPlatform(aPlatform);
                }
                if (!serverQuery.isRunning()) continue;
                mServer = discover.getMBeanServer(serverQuery.getUrl());
                ArrayList<AIServiceValue> aServices = new ArrayList<AIServiceValue>();
                ArrayList services = new ArrayList();
                for (int j = 0; j < serviceQueries.length; ++j) {
                    WeblogicQuery serviceQuery = serviceQueries[j];
                    serviceQuery.setParent(serverQuery);
                    serviceQuery.setVersion(serverQuery.getVersion());
                    discover.find(mServer, serviceQuery, services);
                }
                if (DYNAMIC_SVC_SUPPORTED_WEBLOGIC_VERSION.compareTo(Double.valueOf(serverQuery.getVersion())) <= 0) {
                    JMXConnector jmxConnector = WeblogicUtil.getManagedServerConnection(props);
                    HashSet serviceTypes = new HashSet();
                    try {
                        this.discoverDynamicServices(discover, jmxConnector.getMBeanServerConnection(), serverQuery, services, serviceTypes);
                    }
                    catch (IOException e) {
                        throw new PluginException("Error discovering dynamic services", (Throwable)e);
                    }
                    finally {
                        try {
                            jmxConnector.close();
                        }
                        catch (IOException e) {}
                    }
                    AIServiceTypeValue[] serviceTypeValues = new AIServiceTypeValue[serviceTypes.size()];
                    int count = 0;
                    Iterator iterator = serviceTypes.iterator();
                    while (iterator.hasNext()) {
                        serviceTypeValues[count] = ((ServiceType)iterator.next()).getAIServiceTypeValue();
                        ++count;
                    }
                    aServer.setAiServiceTypes(serviceTypeValues);
                    this.pluginUpdater.updateServiceTypes(this.plugin.getProductPlugin(), serviceTypes);
                }
                for (int k = 0; k < services.size(); ++k) {
                    boolean valid = true;
                    ServiceQuery service = (ServiceQuery)services.get(k);
                    if (service instanceof ApplicationQuery) {
                        valid = ((ApplicationQuery)service).isEAR();
                    }
                    if (valid) {
                        aServices.add(this.generateService(service));
                        continue;
                    }
                    log.debug((Object)("skipped service:" + service.getName()));
                }
                AIServiceValue[] aiservices = aServices.toArray(new AIServiceValue[0]);
                aServer.setAIServiceValues(aiservices);
                if (!serverQuery.isAdmin()) continue;
                ArrayList mgrs = new ArrayList();
                nodemgrQuery.setAdminServer(serverQuery);
                discover.find(mServer, nodemgrQuery, mgrs);
                for (int n = 0; n < mgrs.size(); ++n) {
                    nodemgrQuery = (NodeManagerQuery)mgrs.get(n);
                    aServer = this.generateServer(nodemgrQuery);
                    aPlatform = this.generatePlatform(nodemgrQuery);
                    aPlatform.addAIServerValue((AIServerValue)aServer);
                    rrr.addAIPlatform(aPlatform);
                }
            }
        }
        catch (WeblogicDiscoverException e) {
            throw new PluginException(e.getMessage(), (Throwable)((Object)e));
        }
        return rrr;
    }

    private void discoverDynamicServices(WeblogicDiscover discover, MBeanServerConnection mServer, ServerQuery parent, ArrayList services, Set serviceTypes) throws PluginException, WeblogicDiscoverException {
        try {
            Set<ObjectName> objectNames = mServer.queryNames(new ObjectName("spring.application:*"), null);
            String[] platformTypes = ((ServerTypeInfo)this.plugin.getTypeInfo()).getPlatformTypes();
            ServerTypeInfo server = new ServerTypeInfo(parent.getResourceType(), parent.getDescription(), parent.getVersion());
            server.setValidPlatformTypes(platformTypes);
            for (ObjectName objectName : objectNames) {
                ServiceType serviceType;
                ServiceType identityType;
                MBeanInfo serviceInfo = mServer.getMBeanInfo(objectName);
                if (!(serviceInfo instanceof ModelMBeanInfo) || (identityType = this.serviceTypeFactory.getServiceType(this.plugin.getProductPlugin().getName(), server, (ModelMBeanInfo)((Object)serviceInfo), objectName)) == null) continue;
                if (!serviceTypes.contains(identityType)) {
                    serviceType = this.serviceTypeFactory.create(this.plugin.getProductPlugin(), server, (ModelMBeanInfo)((Object)serviceInfo), objectName);
                    if (serviceType != null) {
                        serviceTypes.add(serviceType);
                    }
                } else {
                    serviceType = this.findServiceType(identityType.getInfo().getName(), serviceTypes);
                }
                String shortServiceType = identityType.getServiceName();
                DynamicServiceQuery dynamicServiceQuery = new DynamicServiceQuery();
                dynamicServiceQuery.setParent(parent);
                dynamicServiceQuery.setType(shortServiceType);
                dynamicServiceQuery.setAttributeNames(serviceType.getCustomProperties().getOptionNames());
                dynamicServiceQuery.setName(objectName.getKeyProperty("name"));
                dynamicServiceQuery.getDynamicAttributes(mServer, objectName);
                services.add(dynamicServiceQuery);
            }
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }

    private ServiceType findServiceType(String serviceName, Set serviceTypes) {
        for (ServiceType serviceType : serviceTypes) {
            if (!serviceType.getInfo().getName().equals(serviceName)) continue;
            return serviceType;
        }
        return null;
    }

    private AIPlatformValue generatePlatform(BaseServerQuery server) {
        AIPlatformValue aiplatform = new AIPlatformValue();
        String serverFqdn = server.getFqdn();
        serverFqdn = this.props.getProperty("weblogic.discover.fqdn." + serverFqdn, serverFqdn);
        String fqdn = serverFqdn;
        if (!fqdn.equals(this.aiplatform.getFqdn())) {
            log.info((Object)("Discovered server (" + server.getResourceFullName() + ") hosted on another platform (fqdn=" + fqdn + ")"));
        }
        fqdn = this.targetFqdn != null ? (this.targetFqdn.equals("same") ? this.aiplatform.getFqdn() : this.targetFqdn) : (serverFqdn.equals("localhost") || serverFqdn.equals("127.0.0.1") ? this.aiplatform.getFqdn() : serverFqdn);
        if (!fqdn.equals(serverFqdn)) {
            log.info((Object)("changing fqdn for " + server.getName() + ": " + serverFqdn + " => " + fqdn));
        }
        aiplatform.setFqdn(fqdn);
        return aiplatform;
    }

    private AIServerExtValue generateServer(BaseServerQuery server) throws PluginException {
        AIServerExtValue aiserver = new AIServerExtValue();
        aiserver.setInstallPath(server.getInstallPath());
        aiserver.setAutoinventoryIdentifier(server.getIdentifier());
        aiserver.setServicesAutomanaged(true);
        aiserver.setServerTypeName(server.getResourceName());
        String name = server.getResourceFullName();
        if (WeblogicProductPlugin.usePlatformName) {
            name = GenericPlugin.getPlatformName() + " " + name;
        }
        aiserver.setName(name);
        String notes = server.getDescription();
        if (notes != null) {
            aiserver.setDescription(notes);
        }
        if (!server.isAdmin()) {
            ConfigResponse productConfig = new ConfigResponse((Map)server.getResourceConfig());
            String listeningPorts = server.getAttribute("ListenPort");
            if (listeningPorts != null && !listeningPorts.equals("")) {
                productConfig.setValue("listen.ports", listeningPorts);
            }
            ConfigResponse metricConfig = new ConfigResponse();
            ConfigResponse cprops = new ConfigResponse((Map)server.getCustomProperties());
            try {
                if (server.hasControl() && !server.isServer61()) {
                    ConfigResponse controlConfig = new ConfigResponse((Map)server.getControlConfig());
                    aiserver.setControlConfig(controlConfig.encode());
                }
                aiserver.setProductConfig(productConfig.encode());
                aiserver.setMeasurementConfig(metricConfig.encode());
                aiserver.setCustomProperties(cprops.encode());
            }
            catch (EncodingException e) {
                throw new PluginException("Error generating config", (Throwable)e);
            }
        }
        log.debug((Object)("discovered server: " + aiserver.getName()));
        return aiserver;
    }

    private AIServiceValue generateService(ServiceQuery service) throws PluginException {
        AIServiceValue aiservice = new AIServiceValue();
        ConfigResponse productConfig = new ConfigResponse((Map)service.getResourceConfig());
        ConfigResponse metricConfig = new ConfigResponse();
        ConfigResponse cprops = new ConfigResponse((Map)service.getCustomProperties());
        String notes = service.getDescription();
        if (notes != null) {
            aiservice.setDescription(notes);
        }
        aiservice.setServiceTypeName(service.getResourceName());
        String name = service.getResourceFullName();
        if (WeblogicProductPlugin.usePlatformName) {
            name = GenericPlugin.getPlatformName() + " " + name;
        }
        if (name.length() >= 200) {
            name = name.substring(0, 199);
        }
        aiservice.setName(name);
        try {
            if (service.hasControl() && !service.isServer61()) {
                ConfigResponse controlConfig = new ConfigResponse((Map)service.getControlConfig());
                aiservice.setControlConfig(controlConfig.encode());
            }
            aiservice.setProductConfig(productConfig.encode());
            aiservice.setMeasurementConfig(metricConfig.encode());
            aiservice.setCustomProperties(cprops.encode());
            if (service.hasResponseTime()) {
                ConfigResponse rtConfig = new ConfigResponse((Map)service.getResponseTimeConfig());
                aiservice.setResponseTimeConfig(rtConfig.encode());
            }
        }
        catch (EncodingException e) {
            throw new PluginException("Error generating config", (Throwable)e);
        }
        log.debug((Object)("discovered service: " + aiservice.getName()));
        return aiservice;
    }
}

