/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.hyperic.hq.plugin.weblogic.jmx.ServiceQuery;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicQuery;

public class DynamicServiceQuery
extends ServiceQuery {
    private String[] attributeNames;
    private String type;
    private Map keyValues = new LinkedHashMap();

    public WeblogicQuery cloneInstance() {
        throw new UnsupportedOperationException();
    }

    public void configure(Properties props) {
        props.put("name", this.getName());
        for (Map.Entry keyEntry : this.keyValues.entrySet()) {
            props.put(keyEntry.getKey(), keyEntry.getValue());
        }
    }

    public String[] getAttributeNames() {
        if (this.attributeNames == null) {
            return super.getAttributeNames();
        }
        return this.attributeNames;
    }

    public boolean getAttributes(MBeanServer mServer, ObjectName name, String[] attrNames) {
        throw new UnsupportedOperationException("This operation is not supported.  Use getDynamicAttributes with WebLogic version 9.1 or higher");
    }

    public boolean getAttributes(MBeanServer mServer, ObjectName name) {
        throw new UnsupportedOperationException("This operation is not supported.  Use getDynamicAttributes with WebLogic version 9.1 or higher");
    }

    public boolean getDynamicAttributes(MBeanServerConnection mServer, ObjectName name) {
        String[] attrNames = this.getAttributeNames();
        if (name == null) {
            return false;
        }
        String alphabeticalkeyProps = name.getCanonicalKeyPropertyListString();
        String[] keyProps = alphabeticalkeyProps.split(",");
        for (int i = 0; i < keyProps.length; ++i) {
            String[] keyProp = keyProps[i].split("=");
            if ("type".equals(keyProp[0]) || "name".equals(keyProp[0]) || "subtype".equals(keyProp[0])) continue;
            this.keyValues.put(keyProp[0], keyProp[1]);
        }
        boolean attributesObtained = this.getAttributes(mServer, name, attrNames);
        this.setName(name.getKeyProperty("name"));
        return attributesObtained;
    }

    private boolean getAttributes(MBeanServerConnection mServer, ObjectName name, String[] attrNames) {
        AttributeList list;
        if (name == null) {
            return false;
        }
        if (attrNames.length == 0) {
            this.setName(name.getKeyProperty("Name"));
            return true;
        }
        try {
            list = mServer.getAttributes(name, attrNames);
        }
        catch (InstanceNotFoundException e) {
            this.logAttrFailure(name, attrNames, e);
            return false;
        }
        catch (ReflectionException e) {
            this.logAttrFailure(name, attrNames, e);
            return false;
        }
        catch (IOException e) {
            this.logAttrFailure(name, attrNames, e);
            return false;
        }
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Attribute attr = (Attribute)list.get(i);
            Object obj = attr.getValue();
            if (obj == null) continue;
            this.attrs.put(attr.getName(), obj.toString());
        }
        return true;
    }

    public String[] getCustomPropertiesNames() {
        if (this.attributeNames == null) {
            return super.getCustomPropertiesNames();
        }
        return this.attributeNames;
    }

    public String getFullName() {
        StringBuffer name = new StringBuffer();
        LinkedHashSet<Object> names = new LinkedHashSet<Object>();
        ArrayList<String> parentNames = new ArrayList<String>();
        WeblogicQuery query = this;
        while ((query = query.getParent()) != null) {
            parentNames.add(query.getQualifiedName());
        }
        for (int i = parentNames.size() - 1; i >= 0; --i) {
            names.add(parentNames.get(i));
        }
        Iterator<Object> iterator = this.keyValues.values().iterator();
        while (iterator.hasNext()) {
            names.add(iterator.next());
        }
        names.add(this.getName());
        iterator = names.iterator();
        while (iterator.hasNext()) {
            name.append((String)iterator.next()).append(" ");
        }
        name.deleteCharAt(name.length() - 1);
        return name.toString();
    }

    public String getResourceType() {
        return this.type;
    }

    public String getScope() {
        throw new UnsupportedOperationException();
    }

    public void setAttributeNames(String[] attributeNames) {
        this.attributeNames = attributeNames;
    }

    public void setType(String type) {
        this.type = type;
    }
}

