/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.services.connector;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractXmlElementConverter;
import com.springsource.hq.plugin.tcserver.serverconfig.services.connector.Connector;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ConnectorConverter
extends AbstractXmlElementConverter {
    private static final String CONNECTOR = "Connector";
    private static final String SCHEME = "scheme";
    private static final String REDIRECT_PORT = "redirectPort";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_NAME = "proxyName";
    private static final String PORT = "port";
    private static final String MAX_THREADS = "maxThreads";
    private static final String CONNECTION_TIMEOUT = "connectionTimeout";
    private static final String ADDRESS = "address";

    protected void convert(Connector connector, Element connectorElement, Properties catalinaProperties) {
        String scheme;
        String redirectPort;
        String proxyPort;
        String proxyName;
        String maxThreads;
        String connectionTimeout;
        String address = this.parseProperties(connectorElement.getAttribute(ADDRESS), catalinaProperties);
        String port = this.parseProperties(connectorElement.getAttribute(PORT), catalinaProperties);
        connector.setId(String.valueOf(address) + ":" + port);
        if (!"".equals(address)) {
            connector.setAddress(address);
        }
        if (!"".equals(connectionTimeout = this.parseProperties(connectorElement.getAttribute(CONNECTION_TIMEOUT), catalinaProperties))) {
            try {
                connector.setConnectionTimeout(Long.valueOf(connectionTimeout));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(CONNECTOR, CONNECTION_TIMEOUT, connectionTimeout);
            }
        }
        if (!"".equals(maxThreads = this.parseProperties(connectorElement.getAttribute(MAX_THREADS), catalinaProperties))) {
            try {
                connector.setMaxThreads(Long.valueOf(maxThreads));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(CONNECTOR, MAX_THREADS, maxThreads);
            }
        }
        if (!"".equals(port)) {
            try {
                connector.setPort(Long.valueOf(port));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(CONNECTOR, PORT, port);
            }
        }
        if (!"".equals(proxyName = this.parseProperties(connectorElement.getAttribute(PROXY_NAME), catalinaProperties))) {
            connector.setProxyName(proxyName);
        }
        if (!"".equals(proxyPort = this.parseProperties(connectorElement.getAttribute(PROXY_PORT), catalinaProperties))) {
            try {
                connector.setProxyPort(Long.valueOf(proxyPort));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(CONNECTOR, PROXY_PORT, proxyPort);
            }
        }
        if (!"".equals(redirectPort = this.parseProperties(connectorElement.getAttribute(REDIRECT_PORT), catalinaProperties))) {
            try {
                connector.setRedirectPort(Long.valueOf(redirectPort));
            }
            catch (NumberFormatException numberFormatException) {
                this.logNonNumericValue(CONNECTOR, REDIRECT_PORT, redirectPort);
            }
        }
        if (!"".equals(scheme = this.parseProperties(connectorElement.getAttribute(SCHEME), catalinaProperties))) {
            connector.setScheme(scheme);
        }
    }

    protected void convert(Document document, Element connectorElement, Connector from, Properties catalinaProperties) {
        this.setAttribute(connectorElement, ADDRESS, from.getAddress(), catalinaProperties, false);
        this.setAttribute(connectorElement, CONNECTION_TIMEOUT, from.getConnectionTimeout(), catalinaProperties, false);
        this.setAttribute(connectorElement, MAX_THREADS, from.getMaxThreads(), catalinaProperties, false);
        this.setAttribute(connectorElement, PORT, from.getPort(), catalinaProperties, false);
        this.setAttribute(connectorElement, PROXY_NAME, from.getProxyName(), catalinaProperties, false);
        this.setAttribute(connectorElement, PROXY_PORT, from.getProxyPort(), catalinaProperties, false);
        this.setAttribute(connectorElement, REDIRECT_PORT, from.getRedirectPort(), catalinaProperties, false);
        this.setAttribute(connectorElement, SCHEME, from.getScheme(), catalinaProperties, false);
    }
}

