/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.discovery;

import com.springsource.hq.plugin.tcserver.plugin.discovery.ControlScriptParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.ServerXmlPropertiesRetriever;
import com.springsource.hq.plugin.tcserver.plugin.wrapper.JmxUtils;
import com.springsource.hq.plugin.tcserver.plugin.wrapper.MxUtilJmxUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.DetectionUtil;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.sigar.ProcCred;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.InvalidOptionException;
import org.hyperic.util.config.InvalidOptionValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TcRuntimeDetector
extends MxServerDetector {
    public static final String SERVER_RESOURCE_CONFIG_CATALINA_HOME = "catalina.home";
    public static final String SERVER_RESOURCE_CONFIG_CATALINA_BASE = "catalina.base";
    private static final String RELATIVE_PATH_CONF_CATALINA_PROPERTIES = "/conf/catalina.properties";
    private static final String CATALINA_BASE_PROP = "-Dcatalina.base=";
    private static final String CATALINA_HOME_PROP = "-Dcatalina.home=";
    private static final String DEFAULT_CONFIG_TRACK_ENABLE = "DEFAULT_CONFIG_TRACK_ENABLE";
    private static final String DEFAULT_LOG_LEVEL = "DEFAULT_LOG_LEVEL";
    private static final String DEFAULT_LOG_TRACK_ENABLE = "DEFAULT_LOG_TRACK_ENABLE";
    private static final String TCRUNTIME_CONTROL_PROGRAM = "tcruntime-ctl";
    private static final String TCSERVER_CONTROL_PROGRAM = "tcserver-ctl";
    private static final String TCRUNTIME_WIN_CONTROL_PROGRAM = "tcruntime-ctl.bat";
    private static final String TCSERVER_WIN_CONTROL_PROGRAM = "tcserver-ctl.bat";
    private static final String TCRUNTIME_UNIX_CONTROL_PROGRAM = "tcruntime-ctl.sh";
    private static final String TCSERVER_UNIX_CONTROL_PROGRAM = "tcserver-ctl.sh";
    private static final String TOMCAT_7_SPECIFIC_JAR = "lib/tomcat-util.jar";
    private static final String DEFAULT_JMX_URL = "service:jmx:rmi:///jndi/rmi://127.0.0.1:6969/jmxrmi";
    private final Log logger = LogFactory.getLog(TcRuntimeDetector.class);
    private final JmxUtils mxUtil = new MxUtilJmxUtils();
    private final ControlScriptParser controlScriptParser = new ControlScriptParser();

    protected void setProductConfig(ServerResource server, ConfigResponse config, long pid) {
        DetectionUtil.populateListeningPorts((long)pid, (ConfigResponse)config, (boolean)true);
        super.setProductConfig(server, config);
    }

    private boolean configureListenerMxURL(ConfigResponse config, String basePath) throws PluginException {
        boolean found;
        block3: {
            found = false;
            ServerXmlPropertiesRetriever propertiesRetriever = new ServerXmlPropertiesRetriever();
            try {
                Map<String, String> listenerProperties = propertiesRetriever.getPropertiesFromFile(String.valueOf(basePath) + "/conf/server.xml", "Listener", "className", "com.springsource.tcserver.serviceability.rmi.JmxSocketListener");
                if (!listenerProperties.isEmpty()) {
                    String bindAddressValue = this.getValueFromPropertiesFile(basePath, listenerProperties.get("bind"));
                    String portValue = this.getValueFromPropertiesFile(basePath, listenerProperties.get("port"));
                    config.setValue(this.mxUtil.getJmxUrlProperty(), "service:jmx:rmi:///jndi/rmi://" + bindAddressValue + ":" + portValue + "/jmxrmi");
                    found = true;
                }
            }
            catch (PluginException e) {
                config.setValue(this.mxUtil.getJmxUrlProperty(), DEFAULT_JMX_URL);
                this.logger.warn((Object)("Unable to retrieve properties for discovery, using default " + this.mxUtil.getJmxUrlProperty() + "=" + DEFAULT_JMX_URL));
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return found;
    }

    protected final List<ServiceResource> discoverMxServices(MBeanServerConnection server, ConfigResponse serverConfig) throws PluginException {
        List services = super.discoverMxServices(server, serverConfig);
        for (ServiceResource service : services) {
            this.enableLogAndConfigTrackPlugins(service);
        }
        return services;
    }

    private void enableLogAndConfigTrackPlugins(ServiceResource service) {
        int logLevel = -1;
        boolean enableConfigTrack = false;
        if (Boolean.valueOf(this.getTypeProperty(service.getType(), DEFAULT_LOG_TRACK_ENABLE)).booleanValue()) {
            logLevel = 6;
            if (this.getTypeProperty(service.getType(), DEFAULT_LOG_LEVEL) != null) {
                try {
                    logLevel = Integer.valueOf(this.getTypeProperty(service.getType(), DEFAULT_LOG_LEVEL));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warn((Object)("Error converting default log level of " + this.getTypeProperty(service.getType(), DEFAULT_LOG_LEVEL) + " to an integer.  The log level will be set to INFO."));
                }
            }
        }
        if (Boolean.valueOf(this.getTypeProperty(service.getType(), DEFAULT_CONFIG_TRACK_ENABLE)).booleanValue()) {
            enableConfigTrack = true;
        }
        if (logLevel != -1 || enableConfigTrack) {
            service.setMeasurementConfig(new ConfigResponse(), logLevel, enableConfigTrack);
        }
    }

    private String getCatalinaBase(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith(CATALINA_BASE_PROP)) {
                return args[i].substring(CATALINA_BASE_PROP.length());
            }
            ++i;
        }
        return null;
    }

    private String getCatalinaHome(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith(CATALINA_HOME_PROP)) {
                return args[i].substring(CATALINA_HOME_PROP.length());
            }
            ++i;
        }
        return null;
    }

    private String getBaseDirectoryName(String catalinaBase) {
        return new File(catalinaBase).getName();
    }

    public final List<ServerResource> getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.setPlatformConfig(platformConfig);
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        List procs = this.getServerProcessList();
        int i = 0;
        while (i < procs.size()) {
            ServerResource serverResource;
            MxServerDetector.MxProcess process = (MxServerDetector.MxProcess)procs.get(i);
            String[] processArgs = process.getArgs();
            String catalinaBase = this.getCatalinaBase(processArgs);
            String catalinaHome = this.getCatalinaHome(processArgs);
            if (!this.isHqTcRuntime(catalinaBase) && this.isTcRuntimeInstance(catalinaHome, catalinaBase) && (serverResource = this.createTcRuntimeServerResource(catalinaHome, catalinaBase, processArgs, process)) != null) {
                servers.add(serverResource);
            }
            ++i;
        }
        return servers;
    }

    protected String getServerName(String defaultServerName) {
        String serverName = this.getTypeProperties().getProperty("TC_SERVER_NAME");
        if (serverName == null) {
            serverName = defaultServerName;
        }
        return serverName;
    }

    protected String getServerDescription(String defaultDescription) {
        String serverDescription = this.getTypeProperties().getProperty("TC_SERVER_DESCRIPTION");
        if (serverDescription == null) {
            serverDescription = defaultDescription;
        }
        return serverDescription;
    }

    private ServerResource createTcRuntimeServerResource(String catalinaHome, String catalinaBase, String[] processArgs, MxServerDetector.MxProcess process) throws PluginException {
        ConfigOption option;
        String query = "State.Name.sw=java,Args.*.eq=-D" + this.getProcHomeProperty() + "=" + catalinaBase;
        ServerResource server = this.newServerResource(catalinaBase);
        server.setDescription(this.getServerDescription(server.getInstallPath()));
        this.adjustClassPath(catalinaBase);
        ConfigResponse config = new ConfigResponse();
        ConfigSchema schema = this.getConfigSchema(this.getTypeInfo().getName(), 0);
        if (schema != null && (option = schema.getOption("process.query")) != null) {
            config.setValue(option.getName(), query);
        }
        if (process.getURL() != null) {
            config.setValue(this.mxUtil.getJmxUrlProperty(), process.getURL());
        } else {
            String[] args = process.getArgs();
            int j = 0;
            while (j < args.length) {
                if (this.configureListenerMxURL(config, catalinaBase) || this.configureMxURL(config, args[j])) break;
                this.configureLocalMxURL(config, args[j], query);
                ++j;
            }
        }
        this.storeProcessUserAndGroup(process, config);
        config.setValue(SERVER_RESOURCE_CONFIG_CATALINA_BASE, catalinaBase);
        config.setValue(SERVER_RESOURCE_CONFIG_CATALINA_HOME, catalinaHome);
        config.setValue("jmx.password", this.getJMXPassword(catalinaBase));
        this.setProductConfig(server, config, process.getPid());
        this.discoverServerConfig(server, process.getPid());
        server.setMeasurementConfig();
        server.setControlConfig();
        server.setName(String.valueOf(TcRuntimeDetector.getPlatformName()) + " " + this.getServerName("tc Runtime") + " " + this.getBaseDirectoryName(catalinaBase));
        ConfigResponse controlConfig = new ConfigResponse();
        String controlProgram = this.determineControlProgram(catalinaHome, catalinaBase);
        controlConfig.setValue("program", controlProgram);
        server.setControlConfig(controlConfig);
        return server;
    }

    private void storeProcessUserAndGroup(MxServerDetector.MxProcess process, ConfigResponse config) throws InvalidOptionException, InvalidOptionValueException, PluginException {
        String group;
        String user;
        block8: {
            user = null;
            group = null;
            try {
                try {
                    ProcCredName procCredName = TcRuntimeDetector.getSigar().getProcCredName(process.getPid());
                    user = procCredName.getUser();
                    group = procCredName.getGroup();
                }
                catch (SigarException se) {
                    this.logger.warn((Object)("Failed to get proc cred names for tc Server process " + process.getPid()));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)se);
                    }
                    try {
                        ProcCred procCred = TcRuntimeDetector.getSigar().getProcCred(process.getPid());
                        user = String.valueOf(procCred.getUid());
                        group = String.valueOf(procCred.getGid());
                    }
                    catch (SigarException sigarException) {
                        this.logger.warn((Object)("Failed to get proc cred for tc Server process " + process.getPid()));
                    }
                    this.logger.info((Object)("Using " + user + "/" + group + " as the user/group for tc Runtime instance process with pid: " + process.getPid()));
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.logger.info((Object)("Using " + user + "/" + group + " as the user/group for tc Runtime instance process with pid: " + process.getPid()));
                throw throwable;
            }
            this.logger.info((Object)("Using " + user + "/" + group + " as the user/group for tc Runtime instance process with pid: " + process.getPid()));
        }
        config.setValue("process.username", user);
        config.setValue("process.group", group);
    }

    private String determineControlProgram(String catalinaHome, String catalinaBase) throws PluginException {
        File installationRoot = this.isCombinedLayoutInstance(catalinaHome, catalinaBase) ? this.getInstallationRootOfCombinedLayoutInstance(catalinaBase) : new File(catalinaHome).getParentFile();
        return this.getControlScript(installationRoot).getAbsolutePath();
    }

    private File getInstallationRootOfCombinedLayoutInstance(String catalinaBase) throws PluginException {
        File controlScript = this.getControlScript(new File(catalinaBase, "bin"));
        return this.controlScriptParser.getInstallBase(catalinaBase, controlScript);
    }

    private File getControlScript(File controlScriptDir) {
        File runtimeControlScript;
        if (TcRuntimeDetector.isWin32()) {
            runtimeControlScript = new File(controlScriptDir, TCRUNTIME_WIN_CONTROL_PROGRAM);
            if (!runtimeControlScript.exists()) {
                runtimeControlScript = new File(controlScriptDir, TCSERVER_WIN_CONTROL_PROGRAM);
            }
        } else {
            runtimeControlScript = new File(controlScriptDir, TCRUNTIME_UNIX_CONTROL_PROGRAM);
            if (!runtimeControlScript.exists()) {
                runtimeControlScript = new File(controlScriptDir, TCSERVER_UNIX_CONTROL_PROGRAM);
            }
        }
        return runtimeControlScript;
    }

    private boolean isCombinedLayoutInstance(String catalinaHome, String catalinaBase) {
        return catalinaHome.equals(catalinaBase);
    }

    private String getValueFromPropertiesFile(String basePath, String property) throws PluginException {
        String propertyValue = property;
        if (property.startsWith("${") && property.endsWith("}")) {
            String propertyKey = property.substring(2, property.length() - 1);
            File catalinaProperties = new File(basePath, RELATIVE_PATH_CONF_CATALINA_PROPERTIES);
            FileInputStream catalinaPropertiesInputStream = null;
            try {
                try {
                    catalinaPropertiesInputStream = new FileInputStream(catalinaProperties);
                    Properties properties = new Properties();
                    properties.load(catalinaPropertiesInputStream);
                    propertyValue = properties.getProperty(propertyKey);
                }
                catch (FileNotFoundException e) {
                    throw new PluginException("Unable to find " + catalinaProperties.getAbsolutePath(), (Throwable)e);
                }
                catch (IOException e) {
                    throw new PluginException("Failed to read " + catalinaProperties.getAbsolutePath(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (catalinaPropertiesInputStream != null) {
                    try {
                        ((InputStream)catalinaPropertiesInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (catalinaPropertiesInputStream != null) {
                try {
                    ((InputStream)catalinaPropertiesInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return propertyValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getJMXPassword(String catalinaBase) {
        String password = "";
        BufferedReader reader = null;
        String passwordFilePath = String.valueOf(catalinaBase) + "/conf/" + "jmxremote.password";
        try {
            File passwordFile = new File(passwordFilePath);
            reader = new BufferedReader(new FileReader(passwordFile));
            String line = reader.readLine();
            while (line != null) {
                if (line.trim().startsWith("admin")) {
                    password = line.substring(5, line.length()).trim();
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)("Unable to locate file: " + passwordFilePath + ". Error message: " + e.getMessage()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
            if (reader == null) return password;
            try {
                reader.close();
                return password;
            }
            catch (IOException iOException) {}
            return password;
        }
        catch (IOException e) {
            try {
                this.logger.error((Object)("Problem loading file: " + passwordFilePath + ". Error message: " + e.getMessage()));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)e);
                }
                if (reader == null) return password;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
                return password;
            }
            catch (IOException iOException) {}
            return password;
        }
        if (reader == null) return password;
        try {
            reader.close();
            return password;
        }
        catch (IOException iOException) {}
        return password;
    }

    private boolean isHqTcRuntime(String catalinaBase) {
        File hq = this.findVersionFile(new File(catalinaBase), Pattern.compile("hq-common.*\\.jar"));
        return hq != null;
    }

    protected boolean isTcRuntimeInstance(String catalinaHome, String catalinaBase) {
        if (catalinaHome == null) {
            return false;
        }
        if (catalinaBase == null) {
            return false;
        }
        return this.isInstallTypeVersion(catalinaHome) || this.isInstallTypeVersion(catalinaBase);
    }

    protected final boolean isTomcat7(String catalinaHome, String catalinaBase) {
        return new File(catalinaHome, TOMCAT_7_SPECIFIC_JAR).exists();
    }
}

