/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin;

import com.springsource.hq.plugin.tcserver.plugin.ControlCommand;
import com.springsource.hq.plugin.tcserver.plugin.ControlCommandConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

final class RootAgentControlCommandConverter
implements ControlCommandConverter {
    private static final String SU_COMMAND_SWITCH = "-c";
    private static final File CONTROL_PROGRAM = new File("/bin/su");
    private final String instanceUserName;

    public RootAgentControlCommandConverter(String instanceUserName) {
        this.instanceUserName = instanceUserName;
    }

    public ControlCommand convert(ControlCommand controlCommand) {
        ArrayList<String> convertedArguments = new ArrayList<String>();
        convertedArguments.add(this.instanceUserName);
        convertedArguments.add(SU_COMMAND_SWITCH);
        convertedArguments.add(this.buildCommandString(controlCommand));
        return new ControlCommand(CONTROL_PROGRAM, convertedArguments);
    }

    private String buildCommandString(ControlCommand controlCommand) {
        StringBuilder commandBuilder = new StringBuilder();
        commandBuilder.append(controlCommand.getControlProgram().getAbsolutePath());
        Iterator<String> argumentIterator = controlCommand.getArguments().iterator();
        while (argumentIterator.hasNext()) {
            commandBuilder.append(" ");
            commandBuilder.append(argumentIterator.next());
        }
        return commandBuilder.toString();
    }
}

