/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.springsource.hyperic.plugin.gemfire;

import com.vmware.springsource.hyperic.plugin.gemfire.GemFireUtils;
import com.vmware.springsource.hyperic.plugin.gemfire.collectors.MemberCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LiveDataPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

public class GemFireLiveData
extends LiveDataPlugin {
    private static final Log log = LogFactory.getLog(GemFireLiveData.class);
    private static final String[] cmds = new String[]{"getMembers", "getDetails", "getSystemID"};
    private static final Map<String, String> namesCache = new HashMap<String, String>();

    public Object getData(String command, ConfigResponse config) throws PluginException {
        Object res;
        block5: {
            res = null;
            log.debug((Object)("[getData] command='" + command + "' config='" + config + "'"));
            try {
                MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)config.toProperties());
                log.debug((Object)("[getData] mServer=" + mServer));
                if ("getDetails".equals(command)) {
                    res = GemFireLiveData.getDetails(mServer);
                    break block5;
                }
                if ("getMembers".equals(command)) {
                    res = GemFireLiveData.getMembers(mServer);
                    break block5;
                }
                if ("getSystemID".equals(command)) {
                    res = GemFireLiveData.getSystemID(mServer);
                    break block5;
                }
                throw new PluginException("command '" + command + "' not found");
            }
            catch (Exception e) {
                throw new PluginException(e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    public String[] getCommands() {
        return cmds;
    }

    public static String getSystemID(MBeanServerConnection mServer) throws Exception {
        ObjectName mbean = new ObjectName("GemFire:type=MemberInfoWithStatsMBean");
        String id = (String)mServer.getAttribute(mbean, "Id");
        if (id.equalsIgnoreCase("n/a")) {
            GemFireLiveData.getMembers(mServer);
            id = GemFireLiveData.getSystemID(mServer);
        }
        return id;
    }

    private static String[][] getMembers(MBeanServerConnection mServer) throws Exception {
        List<String> members = GemFireUtils.getMembers(mServer);
        ArrayList<String[]> names = new ArrayList<String[]>();
        for (String member : members) {
            String name = namesCache.get(member);
            if (name == null) {
                Map detail = GemFireLiveData.getMemberDetails(mServer, member);
                name = (String)detail.get("name");
                namesCache.put(member, name);
            }
            String[] res = new String[]{name, member};
            names.add(res);
        }
        ArrayList<String> idsToRemove = new ArrayList<String>();
        for (String member : namesCache.keySet()) {
            if (members.contains(member)) continue;
            idsToRemove.add(member);
        }
        if (idsToRemove.size() > 0) {
            log.debug((Object)("[getMembers] namesCache.size=" + namesCache.size()));
            log.debug((Object)("[getMembers] idsToRemove.size=" + idsToRemove.size()));
            for (String member : idsToRemove) {
                namesCache.remove(member);
            }
            log.debug((Object)("[getMembers] namesCache.size=" + namesCache.size()));
        }
        return (String[][])names.toArray((T[])new String[0][0]);
    }

    private static Map getDetails(MBeanServerConnection mServer) throws Exception {
        List<String> members = GemFireUtils.getMembers(mServer);
        HashMap<String, Map> data = new HashMap<String, Map>();
        for (String member : members) {
            data.put(member, GemFireLiveData.getMemberDetails(mServer, member));
        }
        return data;
    }

    private static Map getMemberDetails(MBeanServerConnection mServer, String member) throws Exception {
        HashMap details = new HashMap();
        details.putAll(MemberCollector.getMetrics(member, mServer, true));
        return details;
    }
}

