/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.client.AgentCallbackClient;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.RegisterAgentResult;
import org.hyperic.hq.bizapp.shared.lather.RegisterAgent_args;
import org.hyperic.hq.bizapp.shared.lather.RegisterAgent_result;
import org.hyperic.hq.bizapp.shared.lather.UpdateAgent_args;
import org.hyperic.hq.bizapp.shared.lather.UpdateAgent_result;
import org.hyperic.hq.bizapp.shared.lather.UserIsValid_args;
import org.hyperic.hq.bizapp.shared.lather.UserIsValid_result;
import org.hyperic.lather.LatherValue;
import org.hyperic.lather.NullLatherValue;

public class BizappCallbackClient
extends AgentCallbackClient {
    private final Log log = LogFactory.getLog(BizappCallbackClient.class);

    public BizappCallbackClient(ProviderFetcher fetcher, AgentConfig config) {
        super(fetcher);
        if (config.isProxyServerSet()) {
            this.log.info((Object)("Setting proxy server: host=" + config.getProxyIp() + "; port=" + config.getProxyPort()));
            System.setProperty("lather.proxyHost", config.getProxyIp());
            System.setProperty("lather.proxyPort", String.valueOf(config.getProxyPort()));
        }
        String keyStorePropName = AgentConfig.PROP_KEYSTORE_PATH[0];
        System.setProperty(keyStorePropName, config.getBootProperties().getProperty(keyStorePropName));
    }

    public void bizappPing(boolean acceptUnverifiedCertificates) throws AgentCallbackClientException {
        ProviderInfo provider = this.getProvider();
        this.invokeLatherCall(provider, "ping", (LatherValue)NullLatherValue.INSTANCE, acceptUnverifiedCertificates);
    }

    public boolean userIsValid(String user, String pword) throws AgentCallbackClientException {
        ProviderInfo provider = this.getProvider();
        UserIsValid_result res = (UserIsValid_result)this.invokeLatherCall(provider, "userIsValid", (LatherValue)new UserIsValid_args(user, pword));
        return res.isValid();
    }

    public RegisterAgentResult registerAgent(String oldAgentToken, String user, String pword, String authToken, String agentIP, int agentPort, String version, int cpuCount, boolean isNewTransportAgent, boolean unidirectional, boolean acceptCertificates) throws AgentCallbackClientException {
        ProviderInfo provider = this.getProvider();
        RegisterAgent_args args = new RegisterAgent_args();
        args.setUser(user);
        args.setPword(pword);
        if (oldAgentToken != null) {
            args.setAgentToken(oldAgentToken);
        }
        args.setAuthToken(authToken);
        args.setAgentIP(agentIP);
        args.setAgentPort(agentPort);
        args.setVersion(version);
        args.setCpuCount(cpuCount);
        args.setAcceptCertificates(acceptCertificates);
        if (isNewTransportAgent) {
            args.setNewTransportAgent(unidirectional);
        }
        RegisterAgent_result res = (RegisterAgent_result)this.invokeLatherCall(provider, "registerAgent", (LatherValue)args);
        return new RegisterAgentResult(res.getResult());
    }

    public String updateAgent(String agentToken, String user, String pword, String agentIp, int agentPort, boolean isNewTransportAgent, boolean unidirectional, boolean acceptCertificates) throws AgentCallbackClientException {
        ProviderInfo provider = this.getProvider();
        UpdateAgent_args args = new UpdateAgent_args();
        args.setUser(user);
        args.setPword(pword);
        args.setAgentIP(agentIp);
        args.setAgentPort(agentPort);
        args.setAgentToken(agentToken);
        args.setAcceptCertificates(acceptCertificates);
        if (isNewTransportAgent) {
            args.setNewTransportAgent(unidirectional);
        }
        UpdateAgent_result res = (UpdateAgent_result)this.invokeLatherCall(provider, "updateAgent", (LatherValue)args);
        return res.getErrMsg();
    }
}

