/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.client;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.hqapi1.HQApi;
import org.hyperic.hq.hqapi1.ResourceApi;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.ResourcePrototype;
import org.hyperic.hq.hqapi1.types.ResourcePrototypeResponse;
import org.hyperic.hq.hqapi1.types.ResourcesResponse;
import org.hyperic.hq.hqapi1.types.Response;
import org.hyperic.hq.hqapi1.types.ResponseStatus;
import org.hyperic.hq.hqapi1.types.StatusResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HQApiCommandsClient {
    private static final Log log = LogFactory.getLog((String)HQApiCommandsClient.class.getName());
    private HQApi hqApi;

    public HQApiCommandsClient(HQApi hqApi) {
        this.hqApi = hqApi;
    }

    public HQApi getApi() {
        return this.hqApi;
    }

    public ResourcePrototype getResourcePrototype(String name) throws IOException {
        ResourceApi api = this.hqApi.getResourceApi();
        ResourcePrototypeResponse rpr = api.getResourcePrototype(name);
        this.assertSuccess((Response)rpr, "getResourcePrototype(" + name + ")", true);
        ResourcePrototype type = rpr.getResourcePrototype();
        if (log.isDebugEnabled()) {
            log.debug((Object)("'" + name + "' id=" + type.getId()));
        }
        return type;
    }

    public List<Resource> getResources(ResourcePrototype proto, boolean verbose, boolean children) throws IOException {
        ResourceApi api = this.hqApi.getResourceApi();
        ResourcesResponse rezResponse = api.getResources(proto, verbose, children);
        this.assertSuccess((Response)rezResponse, "Getting all " + proto.getName(), false);
        return rezResponse.getResource();
    }

    public void deleteResource(Resource r) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource (" + r.getName() + ") no longer exists. " + " Removing from Hyperic inventory."));
        }
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ResourceApi rApi = this.hqApi.getResourceApi();
        StatusResponse deleteResponse = rApi.deleteResource(r.getId().intValue());
        this.assertSuccess((Response)deleteResponse, "Delete resource id=" + r.getId(), false);
    }

    public void assertSuccess(Response response, String msg, boolean abort) {
        if (ResponseStatus.SUCCESS.equals((Object)response.getStatus())) {
            return;
        }
        String reason = response.getError() == null ? "unknown" : response.getError().getReasonText();
        msg = msg + ": " + reason;
        if (abort) {
            throw new IllegalStateException(msg);
        }
        log.error((Object)msg);
    }
}

