/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConfigException;
import org.hyperic.hq.agent.AgentLifecycle;
import org.hyperic.hq.agent.AgentMonitorValue;
import org.hyperic.hq.agent.AgentStartupCallback;
import org.hyperic.hq.agent.AgentUpgradeManager;
import org.hyperic.hq.agent.diagnostics.AgentDiagnostics;
import org.hyperic.hq.agent.server.AgentConnectionListener;
import org.hyperic.hq.agent.server.AgentNotificationHandler;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.agent.server.CommandDispatcher;
import org.hyperic.hq.agent.server.CommandListener;
import org.hyperic.hq.agent.server.DefaultConnectionListener;
import org.hyperic.hq.agent.server.LoggingOutputStream;
import org.hyperic.hq.agent.server.ServerHandlerLoader;
import org.hyperic.hq.agent.server.monitor.AgentMonitorException;
import org.hyperic.hq.agent.server.monitor.AgentMonitorInterface;
import org.hyperic.hq.agent.server.monitor.AgentMonitorSimple;
import org.hyperic.hq.agent.stats.AgentStatsWriter;
import org.hyperic.hq.bizapp.client.PlugininventoryCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginInfo;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.security.SecurityUtil;
import org.tanukisoftware.wrapper.WrapperManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentDaemon
extends AgentMonitorSimple {
    public static final String NOTIFY_AGENT_UP = AgentDaemon.class.getName() + ".agentUp";
    public static final String NOTIFY_AGENT_DOWN = AgentDaemon.class.getName() + ".agentDown";
    public static final String NOTIFY_AGENT_FAILED_START = AgentDaemon.class.getName() + ".agentFailedStart";
    public static final String PROP_CERTDN = "agent.certDN";
    public static final String PROP_HOSTNAME = "agent.hostName";
    private static final String AGENT_COMMANDS_SERVER_JAR_NAME = "hq-agent-handler-commands";
    private static AgentDaemon mainInstance;
    private static Object mainInstanceLock;
    private final double startTime;
    private static final Log logger;
    private final ServerHandlerLoader handlerLoader;
    private final PluginLoader handlerClassLoader;
    private CommandDispatcher dispatcher;
    private AgentStorageProvider storageProvider;
    private CommandListener listener;
    private AgentTransportLifecycle agentTransportLifecycle;
    private Vector<AgentServerHandler> serverHandlers;
    private Vector<AgentServerHandler> startedHandlers = new Vector();
    private final Hashtable<String, Vector<AgentNotificationHandler>> notifyHandlers = new Hashtable();
    private Hashtable<String, AgentMonitorInterface> monitorClients;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ProductPluginManager ppm;
    private final AgentConfig config;
    private AgentDiagnostics agentDiagnostics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgentDaemon getMainInstance() {
        Object object = mainInstanceLock;
        synchronized (object) {
            return mainInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentDaemon(AgentConfig config) {
        this.handlerClassLoader = PluginLoader.create((String)"ServerHandlerLoader", (ClassLoader)this.getClass().getClassLoader());
        this.handlerLoader = new ServerHandlerLoader((ClassLoader)this.handlerClassLoader);
        this.startTime = System.currentTimeMillis();
        this.config = config;
        Object object = mainInstanceLock;
        synchronized (object) {
            if (mainInstance == null) {
                mainInstance = this;
            }
        }
    }

    public CommandDispatcher getCommandDispatcher() {
        return this.dispatcher;
    }

    private static File getAgentCommandsServerJar(String libHandlersDir) throws FileNotFoundException {
        File[] jars = new File(libHandlersDir).listFiles(new FileFilter(){

            public boolean accept(File file) {
                String name = file.getName();
                return name.startsWith(AgentDaemon.AGENT_COMMANDS_SERVER_JAR_NAME);
            }
        });
        if (jars == null || jars.length != 1) {
            throw new FileNotFoundException("hq-agent-handler-commands jar is not optional");
        }
        return jars[0];
    }

    private static File[] getOtherCommandsServerJars(String libHandlersDir) {
        File[] jars = new File(libHandlersDir).listFiles(new FileFilter(){

            public boolean accept(File file) {
                String name = file.getName();
                return name.endsWith(".jar") && !name.startsWith(AgentDaemon.AGENT_COMMANDS_SERVER_JAR_NAME);
            }
        });
        if (jars == null) {
            return new File[0];
        }
        return jars;
    }

    public static AgentDaemon newInstance(AgentConfig cfg) throws AgentConfigException {
        AgentDaemon res = new AgentDaemon(cfg);
        try {
            res.configure();
        }
        catch (AgentRunningException exc) {
            throw new AgentAssertionException("New agent should not be running", (Throwable)((Object)exc));
        }
        return res;
    }

    public PluginManager getPluginManager(String type) throws AgentRunningException, PluginException {
        if (!this.isRunning()) {
            throw new AgentRunningException("Plugin manager cannot be retrieved if the Agent is not running");
        }
        return this.ppm.getPluginManager(type);
    }

    public AgentStorageProvider getStorageProvider() throws AgentRunningException {
        if (!this.isRunning()) {
            throw new AgentRunningException("Storage cannot be retrieved if the Agent is not running");
        }
        return this.storageProvider;
    }

    public AgentConfig getBootConfig() {
        return this.config;
    }

    public String getCurrentAgentBundle() {
        String agentBundleHome = this.getBootConfig().getBootProperties().getProperty(AgentConfig.PROP_BUNDLEHOME[0]);
        File bundleDir = new File(agentBundleHome);
        return bundleDir.getName();
    }

    public AgentTransportLifecycle getAgentTransportLifecycle() throws AgentRunningException {
        if (!this.isRunning()) {
            throw new AgentRunningException("Agent Transport Lifecycle cannot be retrieved if the Agent is not running");
        }
        return this.agentTransportLifecycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNotifyHandler(AgentNotificationHandler handler, String msgClass) {
        Hashtable<String, Vector<AgentNotificationHandler>> hashtable = this.notifyHandlers;
        synchronized (hashtable) {
            Vector<AgentNotificationHandler> handlers = this.notifyHandlers.get(msgClass);
            if (handlers == null) {
                handlers = new Vector();
                this.notifyHandlers.put(msgClass, handlers);
            }
            handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(String msgClass, String message) {
        Hashtable<String, Vector<AgentNotificationHandler>> hashtable = this.notifyHandlers;
        synchronized (hashtable) {
            Vector<AgentNotificationHandler> handlers = this.notifyHandlers.get(msgClass);
            if (handlers == null) {
                return;
            }
            for (AgentNotificationHandler handler : handlers) {
                handler.handleNotification(msgClass, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanup() throws AgentRunningException {
        if (this.isRunning()) {
            throw new AgentRunningException("Agent cannot be cleaned up while running");
        }
        if (this.startedHandlers != null) {
            for (int i = 0; i < this.startedHandlers.size(); ++i) {
                AgentServerHandler handler = this.startedHandlers.get(i);
                handler.shutdown();
            }
            this.serverHandlers = null;
            this.startedHandlers = null;
        }
        this.dispatcher = null;
        if (this.listener != null) {
            this.listener.cleanup();
            this.listener = null;
        }
        if (this.storageProvider != null) {
            try {
                this.storageProvider.flush();
            }
            catch (AgentStorageException exc) {
                logger.error((Object)"Failed to flush Agent storage", (Throwable)exc);
            }
            finally {
                this.storageProvider.dispose();
                this.storageProvider = null;
            }
        }
        try {
            this.ppm.shutdown();
        }
        catch (PluginException pluginException) {
            // empty catch block
        }
    }

    public static AgentStorageProvider createStorageProvider(AgentConfig cfg) throws AgentConfigException {
        AgentStorageProvider provider;
        Class<?> storageClass;
        try {
            storageClass = Class.forName(cfg.getStorageProvider());
        }
        catch (ClassNotFoundException exc) {
            throw new AgentConfigException("Storage provider not found: " + exc.getMessage());
        }
        try {
            provider = (AgentStorageProvider)storageClass.newInstance();
            provider.init(cfg.getStorageProviderInfo());
        }
        catch (IllegalAccessException exc) {
            throw new AgentConfigException("Unable to access storage provider '" + cfg.getStorageProvider() + "': " + exc.getMessage());
        }
        catch (InstantiationException exc) {
            throw new AgentConfigException("Unable to instantiate storage provider '" + cfg.getStorageProvider() + "': " + exc.getMessage());
        }
        catch (AgentStorageException exc) {
            throw new AgentConfigException("Storage provider unable to initialize: " + exc.getMessage());
        }
        return provider;
    }

    public void configure() throws AgentRunningException, AgentConfigException {
        File agentCommandsServerJar;
        if (this.isRunning()) {
            throw new AgentRunningException("Agent cannot be configured while running");
        }
        String libHandlersLibDir = this.config.getBootProperties().getProperty(AgentConfig.PROP_LIB_HANDLERS_LIB[0]);
        File handlersLib = new File(libHandlersLibDir);
        if (handlersLib.exists()) {
            this.handlerClassLoader.addURL(handlersLib);
        }
        this.dispatcher = new CommandDispatcher();
        this.storageProvider = AgentDaemon.createStorageProvider(this.config);
        String platformName = this.config.getBootProperties().getProperty("platform.name");
        String currentHost = null != platformName ? platformName : GenericPlugin.getPlatformName();
        String storedHost = this.storageProvider.getValue(PROP_HOSTNAME);
        if (storedHost == null || storedHost.length() == 0) {
            this.storageProvider.setValue(PROP_HOSTNAME, currentHost);
        } else if (!storedHost.equals(currentHost)) {
            String err = "Invalid hostname '" + currentHost + "'. This agent " + "has been configured for '" + storedHost + "'. If " + "this agent has been copied from a different machine " + "please remove the data directory and restart the agent";
            throw new AgentConfigException(err);
        }
        this.listener = new CommandListener(this.dispatcher);
        DefaultConnectionListener defListener = new DefaultConnectionListener(this.config);
        this.setConnectionListener(defListener);
        if (this.config.isProxyServerSet()) {
            logger.info((Object)("Setting proxy server: host=" + this.config.getProxyIp() + "; port=" + this.config.getProxyPort()));
            System.setProperty("lather.proxyHost", this.config.getProxyIp());
            System.setProperty("lather.proxyPort", String.valueOf(this.config.getProxyPort()));
        }
        this.serverHandlers = new Vector();
        String libHandlersDir = this.config.getBootProperties().getProperty(AgentConfig.PROP_LIB_HANDLERS[0]);
        try {
            agentCommandsServerJar = AgentDaemon.getAgentCommandsServerJar(libHandlersDir);
        }
        catch (FileNotFoundException e) {
            throw new AgentConfigException(e.getMessage());
        }
        this.loadAgentServerHandlerJars(new File[]{agentCommandsServerJar});
        File[] otherCommandsServerJars = AgentDaemon.getOtherCommandsServerJars(libHandlersDir);
        this.loadAgentServerHandlerJars(otherCommandsServerJars);
        String certDN = this.storageProvider.getValue(PROP_CERTDN);
        if (certDN == null || certDN.length() == 0) {
            certDN = this.generateCertDN();
            this.storageProvider.setValue(PROP_CERTDN, certDN);
            try {
                this.storageProvider.flush();
            }
            catch (AgentStorageException ase) {
                throw new AgentConfigException("Error storing certdn in agent storage: " + (Object)((Object)ase));
            }
        }
    }

    private void loadAgentServerHandlerJars(File[] libJars) throws AgentConfigException {
        ClassLoader currentContext = Thread.currentThread().getContextClassLoader();
        for (File libJar : libJars) {
            try {
                JarFile jarFile = new JarFile(libJar);
                Manifest manifest = jarFile.getManifest();
                String mainClass = manifest.getMainAttributes().getValue("Main-Class");
                if (mainClass != null) {
                    String jarPath = libJar.getAbsolutePath();
                    AgentServerHandler loadedHandler = this.handlerLoader.loadServerHandler(jarPath);
                    this.serverHandlers.add(loadedHandler);
                    this.dispatcher.addServerHandler(loadedHandler);
                }
                jarFile.close();
            }
            catch (Exception e) {
                throw new AgentConfigException("Failed to load '" + libJar + "': " + e.getMessage());
            }
        }
        Thread.currentThread().setContextClassLoader(currentContext);
    }

    private String generateCertDN() {
        return "CAM-AGENT-" + SecurityUtil.generateRandomToken();
    }

    public String[] getMonitors() throws AgentMonitorException {
        return this.monitorClients.keySet().toArray(new String[0]);
    }

    public double getStartTime() throws AgentMonitorException {
        return this.startTime;
    }

    public double getUpTime() throws AgentMonitorException {
        return (double)System.currentTimeMillis() - this.startTime;
    }

    public double getJVMTotalMemory() throws AgentMonitorException {
        return Runtime.getRuntime().totalMemory();
    }

    public double getJVMFreeMemory() throws AgentMonitorException {
        return Runtime.getRuntime().freeMemory();
    }

    public double getNumActiveThreads() throws AgentMonitorException {
        return Thread.activeCount();
    }

    public void registerMonitor(String monitorName, AgentMonitorInterface monitor) {
        this.monitorClients.put(monitorName, monitor);
    }

    public AgentMonitorValue[] getMonitorValues(String monitorName, String[] monitorKeys) {
        AgentMonitorInterface iface = this.monitorClients.get(monitorName);
        if (iface == null) {
            AgentMonitorValue badVal = new AgentMonitorValue();
            badVal.setErrCode(3);
            AgentMonitorValue[] res = new AgentMonitorValue[monitorKeys.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = badVal;
            }
            return res;
        }
        return iface.getMonitorValues(monitorKeys);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void die() throws AgentRunningException {
        if (!this.running.get()) {
            throw new AgentRunningException("Agent is not running");
        }
        this.listener.die();
        this.running.set(false);
        this.storageProvider.dispose();
        this.agentDiagnostics.die();
    }

    public void setConnectionListener(AgentConnectionListener newListener) throws AgentRunningException {
        this.listener.setConnectionListener(newListener);
    }

    private void startPluginManagers() throws AgentStartException {
        try {
            Properties bootProps = this.config.getBootProperties();
            this.ppm = new ProductPluginManager(bootProps);
            this.ppm.init();
            String pluginDir = bootProps.getProperty(AgentConfig.PROP_PDK_PLUGIN_DIR[0]);
            TreeSet<PluginInfo> excludes = new TreeSet<PluginInfo>(new Comparator<PluginInfo>(){

                @Override
                public int compare(PluginInfo p1, PluginInfo p2) {
                    return p1.name.compareTo(p2.name);
                }
            });
            Set<PluginInfo> plugins = new HashSet<PluginInfo>();
            plugins.addAll(this.ppm.registerPlugins(pluginDir, excludes));
            plugins.addAll(excludes);
            this.scanLegacyCustomDir("..");
            Collection fromDirs = this.ppm.getAllPluginInfoDirectFromFileSystem(pluginDir);
            plugins = this.mergeByName(fromDirs, plugins);
            this.sendPluginStatusToServer(plugins);
            logger.info((Object)"Product Plugin Manager initalized");
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing plugins ", (Throwable)e);
            throw new AgentStartException("Unable to initialize plugin manager: " + e.getMessage());
        }
    }

    private void scanLegacyCustomDir(String startDir) {
        File dir = new File(startDir).getAbsoluteFile();
        String fs = File.separator;
        while (dir != null) {
            File customDir = null;
            try {
                customDir = new File(dir, "hq-plugins");
            }
            catch (NullPointerException e) {
                logger.warn((Object)("cannot scan custom plugin dir " + dir + fs + "hq-plugins, please note the plugins in this " + "directory will not be supported anymore instead they must to be managed via the " + "HQ Server Plugin Manager UI."));
                continue;
            }
            if (customDir.exists() && customDir.isDirectory()) {
                File[] files;
                for (File file : files = customDir.listFiles()) {
                    String name = file.getName();
                    if (!name.endsWith("-plugin.jar") && !name.endsWith("-plugin.xml")) continue;
                    logger.warn((Object)("WARNING - custom plugins on the agent are no longer supported.  Will not load plugin - " + name + ", instead add this plugin " + "to the HQ Server via the Plugin Manager UI."));
                }
                return;
            }
            dir = dir.getParentFile();
        }
    }

    private Set<PluginInfo> mergeByName(Collection<PluginInfo> fromDirs, Set<PluginInfo> plugins) {
        HashSet<String> pluginFiles = new HashSet<String>();
        for (PluginInfo info : plugins) {
            pluginFiles.add(info.jar);
        }
        for (PluginInfo info : fromDirs) {
            if (pluginFiles.contains(info.jar)) continue;
            plugins.add(info);
        }
        return plugins;
    }

    private void sendPluginStatusToServer(final Collection<PluginInfo> plugins) {
        Thread thread = new Thread("PluginStatusSender"){

            public void run() {
                while (true) {
                    try {
                        AgentStorageProvider provider;
                        while ((provider = AgentDaemon.this.getStorageProvider()) == null) {
                            logger.debug((Object)"trying to send plugin status to the server but provider has not been setup, will sleep 5 seconds and retry");
                            Thread.sleep(5000L);
                        }
                        PlugininventoryCallbackClient client = new PlugininventoryCallbackClient((ProviderFetcher)new StorageProviderFetcher(provider), plugins);
                        logger.info((Object)"Sending plugin status to server");
                        client.sendPluginReportToServer();
                        logger.info((Object)"Successfully sent plugin status to server");
                    }
                    catch (Exception e) {
                        logger.warn((Object)("could not send plugin status to server, will retry:  " + e));
                        logger.debug((Object)e, (Throwable)e);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e2) {
                            logger.debug((Object)e2, (Throwable)e2);
                        }
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private void startHandlers() throws AgentStartException {
        for (int i = 0; i < this.serverHandlers.size(); ++i) {
            AgentServerHandler handler = this.serverHandlers.get(i);
            try {
                handler.startup(this);
            }
            catch (AgentStartException exc) {
                logger.error((Object)("Error starting plugin " + handler), (Throwable)((Object)exc));
                throw exc;
            }
            catch (Exception exc) {
                logger.error((Object)"Unknown exception", (Throwable)exc);
                throw new AgentStartException("Error starting plugin " + handler, exc);
            }
            this.startedHandlers.add(handler);
        }
    }

    private final void postInitActions() throws AgentStartException {
        for (AgentServerHandler handler : this.startedHandlers) {
            handler.postInitActions();
        }
    }

    private void cleanTmpDir(String tmp) {
        File dir = new File(tmp);
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                file.delete();
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
    }

    private PrintStream newLogStream(String stream, Properties props) {
        Logger logger = Logger.getLogger((String)stream);
        String logLevel = props.getProperty("agent.logLevel." + stream);
        if (logLevel == null) {
            return null;
        }
        Level level = Level.toLevel((String)logLevel);
        return new PrintStream(new LoggingOutputStream((Category)logger, (Priority)level), true);
    }

    private void redirectStreams(Properties props) {
        PrintStream stream = this.newLogStream("SystemOut", props);
        if (stream != null) {
            System.setOut(stream);
        }
        if ((stream = this.newLogStream("SystemErr", props)) != null) {
            System.setErr(stream);
        }
    }

    /*
     * Loose catch block
     */
    public void start() throws AgentStartException {
        block23: {
            boolean agentStarted;
            block21: {
                this.running.set(true);
                agentStarted = false;
                logger.info((Object)("Agent starting up, bundle name=" + this.getCurrentAgentBundle()));
                Properties bootProps = this.config.getBootProperties();
                String tmpDir = bootProps.getProperty(AgentConfig.PROP_TMPDIR[0]);
                if (tmpDir != null) {
                    try {
                        List updatedPlugins = AgentUpgradeManager.updatePlugins((Properties)bootProps);
                        if (!updatedPlugins.isEmpty()) {
                            logger.info((Object)("Successfully updated plugins: " + updatedPlugins));
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to update plugins", (Throwable)e);
                    }
                    this.cleanTmpDir(tmpDir);
                    System.setProperty("java.io.tmpdir", tmpDir);
                }
                this.monitorClients = new Hashtable();
                this.registerMonitor("agent", this);
                this.registerMonitor("agent.commandListener", this.listener);
                this.redirectStreams(bootProps);
                String agentTransportLifecycleClass = "org.hyperic.hq.agent.server.AgentTransportLifecycleImpl";
                try {
                    Class clazz = this.handlerClassLoader.loadClass(agentTransportLifecycleClass);
                    Constructor constructor = clazz.getConstructor(AgentDaemon.class, AgentConfig.class, AgentStorageProvider.class);
                    this.agentTransportLifecycle = (AgentTransportLifecycle)constructor.newInstance(this, this.getBootConfig(), this.getStorageProvider());
                }
                catch (ClassNotFoundException e) {
                    throw new AgentStartException("Cannot find agent transport lifecycle class: " + agentTransportLifecycleClass);
                }
                this.startPluginManagers();
                this.startHandlers();
                this.agentTransportLifecycle.startAgentTransport();
                this.listener.setup();
                this.tryForceAgentFailure();
                logger.info((Object)"Agent started successfully");
                this.sendNotification(NOTIFY_AGENT_UP, "we're up, baby!");
                agentStarted = true;
                AgentStatsWriter statsWriter = new AgentStatsWriter(this.config);
                statsWriter.startWriter();
                this.postInitActions();
                this.agentDiagnostics = AgentDiagnostics.getInstance();
                this.agentDiagnostics.setConfig(this.config);
                this.agentDiagnostics.start();
                this.listener.listenLoop();
                this.sendNotification(NOTIFY_AGENT_DOWN, "goin' down, baby!");
                statsWriter.stopWriter();
                Object var8_12 = null;
                if (agentStarted) break block21;
                logger.debug((Object)"Notifying that agent startup failed");
                this.sendNotification(NOTIFY_AGENT_FAILED_START, "agent startup failed!");
            }
            if (this.agentTransportLifecycle != null) {
                this.agentTransportLifecycle.stopAgentTransport();
            }
            this.running.set(false);
            try {
                this.cleanup();
            }
            catch (AgentRunningException e) {
                logger.error((Object)e, (Throwable)((Object)e));
            }
            if (this.storageProvider != null) {
                this.storageProvider.dispose();
            }
            break block23;
            {
                catch (AgentStartException exc) {
                    logger.error((Object)exc.getMessage(), (Throwable)((Object)exc));
                    throw exc;
                }
                catch (Exception exc) {
                    logger.error((Object)"Error running agent", (Throwable)exc);
                    throw new AgentStartException("Error running agent: " + exc.getMessage());
                }
                catch (Throwable exc) {
                    logger.error((Object)"Critical error running agent", exc);
                    if (this.storageProvider != null) {
                        this.storageProvider.dispose();
                        this.storageProvider = null;
                    }
                    throw new AgentStartException("Critical shutdown");
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                if (!agentStarted) {
                    logger.debug((Object)"Notifying that agent startup failed");
                    this.sendNotification(NOTIFY_AGENT_FAILED_START, "agent startup failed!");
                }
                if (this.agentTransportLifecycle != null) {
                    this.agentTransportLifecycle.stopAgentTransport();
                }
                this.running.set(false);
                try {
                    this.cleanup();
                }
                catch (AgentRunningException e) {
                    logger.error((Object)e, (Throwable)((Object)e));
                }
                if (this.storageProvider != null) {
                    this.storageProvider.dispose();
                }
                logger.info((Object)"Agent shut down");
                System.exit(0);
                throw throwable;
            }
        }
        logger.info((Object)"Agent shut down");
        System.exit(0);
    }

    private void tryForceAgentFailure() throws AgentStartException {
        String rollbackBundle = this.getBootConfig().getBootProperties().getProperty(AgentConfig.PROP_ROLLBACK_AGENT_BUNDLE_UPGRADE[0]);
        if (this.getCurrentAgentBundle().equals(rollbackBundle)) {
            throw new AgentStartException(AgentConfig.PROP_ROLLBACK_AGENT_BUNDLE_UPGRADE[0] + " property set to force rollback of agent bundle upgrade: " + rollbackBundle);
        }
    }

    static {
        mainInstanceLock = new Object();
        logger = LogFactory.getLog(AgentDaemon.class);
    }

    public static class RunnableAgent
    implements Runnable,
    AgentLifecycle {
        private final AgentConfig config;
        private AgentDaemon agent;

        public RunnableAgent(AgentConfig config) {
            this.config = config;
        }

        public void shutdown() {
            try {
                if (this.agent != null) {
                    this.agent.die();
                    this.agent.cleanup();
                }
            }
            catch (Throwable e) {
                logger.error((Object)e, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean isConfigured = false;
            try {
                this.agent = AgentDaemon.newInstance(this.config);
                isConfigured = true;
            }
            catch (Throwable e) {
                logger.error((Object)"Agent configuration failed: ", e);
            }
            finally {
                if (!isConfigured) {
                    this.cleanUpOnAgentConfigFailure(this.config);
                }
            }
            boolean isStarted = false;
            if (this.agent != null) {
                try {
                    this.agent.start();
                    isStarted = true;
                }
                catch (AgentStartException e) {
                    logger.error((Object)"Agent startup error: ", (Throwable)((Object)e));
                }
                catch (Exception e) {
                    logger.error((Object)"Agent startup failed: ", (Throwable)e);
                }
                finally {
                    if (!isStarted) {
                        this.cleanUpOnAgentStartFailure();
                    }
                }
            }
        }

        private void cleanUpOnAgentConfigFailure(AgentConfig config) {
            try {
                AgentStartupCallback agentStartupCallback = new AgentStartupCallback(config);
                agentStartupCallback.onAgentStartup(false);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to callback on startup failure.", (Throwable)e);
            }
            this.cleanUpOnAgentStartFailure();
        }

        private void cleanUpOnAgentStartFailure() {
            if (!WrapperManager.isControlledByNativeWrapper()) {
                System.exit(-1);
            } else {
                this.rollbackAndRestartJVM();
            }
        }

        private void rollbackAndRestartJVM() {
            logger.info((Object)"Attempting to rollback agent bundle");
            boolean success = false;
            try {
                success = AgentUpgradeManager.rollback();
            }
            catch (IOException e) {
                logger.error((Object)"Unable to rollback agent bundle", (Throwable)e);
            }
            if (success) {
                logger.info((Object)"Rollback of agent bundle was successful");
            } else {
                logger.error((Object)"Rollback of agent bundle was not successful");
            }
            logger.info((Object)"Restarting JVM...");
            AgentUpgradeManager.restartJVM();
        }
    }
}

