/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sybase;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.sybase.SybaseProductPlugin;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.CollectorResult;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.jdbc.DBUtil;

public class SybaseSysmonCollector
extends Collector {
    public static final String INTERVAL = "interval";
    static Log trace = LogFactory.getLog((String)("trace." + SybaseSysmonCollector.class));
    static Log log = LogFactory.getLog(SybaseSysmonCollector.class);
    private CallableStatement stmt;
    private Connection conn = null;

    protected void init() throws PluginException {
        Properties props = this.getProperties();
        Connection c = null;
        ResultSet rs = null;
        CallableStatement st = null;
        String sa_role = SybaseProductPlugin.getSaRole();
        try {
            c = this.createConnection(props);
            st = c.prepareCall("{call sp_displayroles}");
            rs = st.executeQuery();
            boolean roleOK = false;
            while (rs.next() && !roleOK) {
                roleOK = rs.getString(1).equals(sa_role);
            }
            if (!roleOK) {
                throw new PluginException("Could not connect using information provided: The user must have System Administrator ('" + sa_role + "') role");
            }
        }
        catch (SQLException e) {
            try {
                throw new PluginException("Could not connect using information provided", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)log, (Connection)c, st, rs);
                throw throwable;
            }
        }
        DBUtil.closeJDBCObjects((Object)log, (Connection)c, (Statement)st, (ResultSet)rs);
        String interval = props.getProperty(INTERVAL);
        Pattern p = Pattern.compile("^\\d\\d:\\d\\d:\\d\\d$");
        Matcher m = p.matcher(interval);
        if (!m.matches()) {
            String msg = "Configuration failed: bad INTERVAL format ##:##:## (" + interval + ")";
            throw new PluginException(msg);
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        Properties props = this.getProperties();
        log.debug((Object)("[collect] props=" + props));
        try {
            this.setAvailability(0.0);
            if (this.conn == null) {
                this.conn = this.createConnection(props);
            }
            this.stmt = this.conn.prepareCall("{call sp_sysmon '" + props.getProperty(INTERVAL) + "'}");
            this.stmt.executeUpdate();
            StringBuffer response = new StringBuffer();
            SQLWarning war = this.stmt.getWarnings();
            do {
                response.append(war.getMessage()).append("\n");
            } while ((war = war.getNextWarning()) != null);
            trace.debug((Object)response);
            String res = response.toString();
            Pattern pat = Pattern.compile("\n +Cache:(.*)\n");
            Matcher m = pat.matcher(res);
            while (m.find()) {
                String cacheName = m.group(1).trim().replaceAll(" ", "_");
                if (trace.isDebugEnabled()) {
                    trace.debug((Object)("->'" + cacheName + "'"));
                    trace.debug((Object)("->" + m.start()));
                }
                String sec = res.substring(m.start());
                this.setValue(cacheName + ".Availability", 1.0);
                this.setValue(cacheName + ".CacheHitsRatio", this.get(sec, "Cache Hits", 5) / 100.0);
                this.setValue(cacheName + ".CacheMissesRatio", this.get(sec, "Cache Misses", 5) / 100.0);
            }
            pat = Pattern.compile("\n +Engine (\\d)+\\s+(\\d+\\.\\d+) %.*");
            m = pat.matcher(res);
            while (m.find()) {
                try {
                    String engineId = m.group(1);
                    String cpuBusyVal = m.group(2);
                    if (engineId != null && cpuBusyVal != null) {
                        this.setValue("EngineUtilization" + engineId.trim(), Double.parseDouble(cpuBusyVal.trim()) / 100.0);
                    }
                    if (!trace.isDebugEnabled()) continue;
                    trace.debug((Object)("Found Engine Utilization for engineid=" + engineId.trim() + " with value " + Double.parseDouble(cpuBusyVal.trim()) / 100.0));
                }
                catch (NumberFormatException e) {
                    if (!trace.isDebugEnabled()) continue;
                    trace.debug((Object)("Unable to parse number from: " + e.toString()));
                }
                catch (IndexOutOfBoundsException e) {
                    if (!trace.isDebugEnabled()) continue;
                    trace.debug((Object)("Unable to find group from matcher: " + e.toString()));
                }
            }
            this.setValue("Deadlocks", this.get(res, "Deadlock Percentage", 5));
            this.setValue("TotalLockReqs", this.get(res, "Total Lock Requests", 5));
            this.setValue("AvgLockContention", this.get(res, "Avg Lock Contention", 5));
            this.setValue("TotalCacheHitsRatio", this.get(res, "Total Cache Hits", 6) / 100.0);
            this.setValue("TotalCacheMissesRatio", this.get(res, "Total Cache Misses", 6) / 100.0);
            this.setValue("TDSPacketsReceived", this.get(res, "Total TDS Packets Rec'd", 6) / 100.0);
            this.setValue("TDSPacketsSent", this.get(res, "Total Bytes Rec'd", 5) / 100.0);
            this.setAvailability(1.0);
        }
        catch (SQLException e) {
            this.setValue("Availability", 0.0);
            log.debug((Object)("[collect] Error " + e.getMessage()));
            log.debug((Object)("[collect] Error " + this.getResult().toString()));
            if (this.conn != null) {
                DBUtil.closeJDBCObjects((Object)log, (Connection)this.conn, null, null);
                this.conn = null;
            }
        }
        finally {
            if (this.conn != null) {
                DBUtil.closeJDBCObjects((Object)log, null, (Statement)this.stmt, null);
            }
        }
    }

    public MetricValue getValue(Metric metric, CollectorResult result) {
        MetricValue res = super.getValue(metric, result);
        if (metric.isAvail() && res.isNone()) {
            res = new MetricValue(0.0);
        }
        return res;
    }

    private double get(String txt, String pro, int index) {
        double res = Double.NaN;
        String[] vals = null;
        try {
            Pattern pat = Pattern.compile(".*" + pro + ".*\r?\n");
            Matcher lm = pat.matcher(txt);
            if (lm.find()) {
                String line = lm.group();
                line = line.trim().replaceAll(" +", " ");
                vals = line.split(" ");
                if (trace.isDebugEnabled()) {
                    trace.debug((Object)line);
                    trace.debug((Object)line);
                    trace.debug(Arrays.asList(vals));
                }
                res = !vals[index].equals("n/a") ? Double.parseDouble(vals[index]) : 0.0;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            res = Double.NaN;
            trace.debug((Object)("vals=> '" + Arrays.asList(vals) + "' pro='" + pro + "' index='" + index + "'"));
        }
        return res;
    }

    protected Connection createConnection(Properties p) throws SQLException {
        String url = p.getProperty("jdbcUrl", "");
        String user = p.getProperty("jdbcUser", "");
        String pass = p.getProperty("jdbcPassword", "");
        pass = pass.matches("^\\s*$") ? "" : pass;
        Properties props = new Properties();
        props.put("CHARSET_CONVERTER_CLASS", "com.sybase.jdbc3.utils.TruncationConverter");
        props.put("user", user);
        props.put("password", pass);
        return DriverManager.getConnection(url, props);
    }
}

