/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor.data;

import org.hyperic.cm.filemonitor.data.EventActionsEnum;

public class EventMessage {
    private EventActionsEnum type;
    private String fullPath;
    private String oldFullPath;
    private boolean isBaseline;
    private byte[] fileBuf;
    private int treeDepth;
    private String revisionId;
    private String oldRevisionId;
    private String diff;
    private Long timestamp;

    public EventMessage(EventActionsEnum type, String fullPath, Long timestamp) {
        this(type, fullPath, false, timestamp);
    }

    public EventMessage(EventActionsEnum type, String fullPath, boolean isBaseline, Long timestamp) {
        this(type, fullPath, null, timestamp);
        this.isBaseline = isBaseline;
    }

    public EventMessage(EventActionsEnum type, String fullPath, String oldFullPath, Long timestamp) {
        this.type = type;
        this.fullPath = fullPath;
        this.oldFullPath = oldFullPath;
        this.isBaseline = false;
        this.fileBuf = null;
        this.treeDepth = -1;
        this.timestamp = timestamp;
    }

    public EventMessage(EventActionsEnum type, String fullPath, Long timestamp, byte[] buf) {
        this(type, fullPath, timestamp);
        this.fileBuf = buf;
    }

    public EventMessage(EventActionsEnum type, String fullPath, Long timestamp, int treeDepth) {
        this(type, fullPath, timestamp);
        this.treeDepth = treeDepth;
    }

    public EventMessage(EventMessage event) {
        this(event.type, event.fullPath, event.oldFullPath, event.timestamp);
    }

    public EventActionsEnum getType() {
        return this.type;
    }

    public void setType(EventActionsEnum type) {
        this.type = type;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public String getOldFullPath() {
        return this.oldFullPath;
    }

    public void setOldFullPath(String oldFullPath) {
        this.oldFullPath = oldFullPath;
    }

    public boolean isBaseline() {
        return this.isBaseline;
    }

    public void setBaseline(boolean isBaseline) {
        this.isBaseline = isBaseline;
    }

    public byte[] getFileBuf() {
        return this.fileBuf;
    }

    public void setFileBuf(byte[] fileBuf) {
        this.fileBuf = fileBuf;
    }

    public int getTreeDepth() {
        return this.treeDepth;
    }

    public void setTreeDepth(int treeDepth) {
        this.treeDepth = treeDepth;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(String versionControlRevisionId) {
        this.revisionId = versionControlRevisionId;
    }

    public String getOldRevisionId() {
        return this.oldRevisionId;
    }

    public void setOldRevisionId(String oldRevisionId) {
        this.oldRevisionId = oldRevisionId;
    }

    public String getDiff() {
        return this.diff;
    }

    public void setDiff(String diff) {
        this.diff = diff;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(EventMessage other) {
        if (this.oldFullPath == null) {
            return this.type.equals((Object)other.type) && this.fullPath.equals(other.fullPath);
        }
        return other.oldFullPath == null ? false : this.type.equals((Object)other.type) && this.fullPath.equals(other.fullPath) && this.oldFullPath.equals(other.oldFullPath);
    }
}

