/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.mx;

import com.vmware.vfabric.hyperic.plugin.vfgf.GFVersionInfo;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberInfo;
import com.vmware.vfabric.hyperic.plugin.vfgf.mx.AbstractGFJmxConnection;
import com.vmware.vfabric.hyperic.plugin.vfgf.util.GFMXUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFJmxConnection
extends AbstractGFJmxConnection {
    private static final Log log = LogFactory.getLog(GFJmxConnection.class);

    public GFJmxConnection(ConfigResponse config) {
        super(config);
    }

    public GFJmxConnection(Properties props) {
        super(props);
    }

    public String[] getCacheServers() {
        ObjectName[] mServers;
        ArrayList<String> list = new ArrayList<String>();
        for (ObjectName objectName : mServers = this.manageCacheServers()) {
            list.add(GFMXUtils.getId(objectName));
        }
        return list.toArray(new String[0]);
    }

    public Map<String, String[]> getCacheVmsAttributes() {
        ObjectName[] mServers;
        Hashtable<String, String[]> map = new Hashtable<String, String[]>();
        for (ObjectName objectName : mServers = this.manageCacheServers()) {
            try {
                MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
                String cwd = (String)mServer.getAttribute(objectName, "workingDirectory");
                String name = (String)mServer.getAttribute(objectName, "name");
                String host = (String)mServer.getAttribute(objectName, "host");
                String[] atts = new String[]{cwd, host, name};
                map.put(GFMXUtils.getId(objectName), atts);
                log.debug((Object)("[getCacheVmsAttributes] id: " + objectName.getCanonicalName()));
                log.debug((Object)("[getCacheVmsAttributes] cwd: " + cwd));
                log.debug((Object)("[getCacheVmsAttributes] name: " + name));
                log.debug((Object)("[getCacheVmsAttributes] host: " + host));
            }
            catch (Exception e) {
                log.debug((Object)("[getCacheVmsAttributes] " + e.getMessage()), (Throwable)e);
            }
        }
        return map;
    }

    public Map<String, Object> getCacheVmAttributes(String gfid, String[] keys) throws InstanceNotFoundException, MalformedURLException, IOException, ReflectionException {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
        ObjectName bean = this.getCacheServerObject(gfid);
        AttributeList attlist = mServer.getAttributes(bean, keys);
        for (int i = 0; i < attlist.size(); ++i) {
            Attribute o = (Attribute)attlist.get(i);
            map.put(keys[i], o.getValue());
        }
        return map;
    }

    public Map<String, Object> getApplicationAttributes(String gfid, String[] keys) throws InstanceNotFoundException, MalformedURLException, IOException, ReflectionException {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
        ObjectName bean = this.getApplicationObject(gfid);
        AttributeList attlist = mServer.getAttributes(bean, keys);
        for (int i = 0; i < attlist.size(); ++i) {
            Attribute o = (Attribute)attlist.get(i);
            map.put(keys[i], o.getValue());
        }
        return map;
    }

    public MemberInfo[] getCacheVmMembers() {
        ObjectName[] mServers;
        ArrayList<MemberInfo> members = new ArrayList<MemberInfo>();
        for (ObjectName objectName : mServers = this.manageCacheServers()) {
            try {
                MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
                String cwd = (String)mServer.getAttribute(objectName, "workingDirectory");
                String name = (String)mServer.getAttribute(objectName, "name");
                String host = (String)mServer.getAttribute(objectName, "host");
                String[] atts = new String[]{cwd, host, name};
                members.add(new MemberInfo(GFMXUtils.getId(objectName), name, host, cwd, 1));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("id: " + objectName.getCanonicalName()));
                log.debug((Object)("cwd: " + cwd));
                log.debug((Object)("name: " + name));
                log.debug((Object)("host: " + host));
            }
            catch (Exception e) {
                log.info((Object)"[getCacheVmMembers] Unable to request cache members.", (Throwable)e);
            }
        }
        return members.toArray(new MemberInfo[0]);
    }

    public MemberInfo[] getSystemMemberApplications() {
        ObjectName[] mServers;
        ArrayList<MemberInfo> members = new ArrayList<MemberInfo>();
        for (ObjectName objectName : mServers = this.manageSystemMembersApplications()) {
            try {
                MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
                String name = (String)mServer.getAttribute(objectName, "name");
                String host = (String)mServer.getAttribute(objectName, "host");
                members.add(new MemberInfo(GFMXUtils.getId(objectName), name, host, "", 2));
                log.debug((Object)("[getSystemMemberApplications] id: " + objectName.getCanonicalName()));
                log.debug((Object)("[getSystemMemberApplications] name: " + name));
                log.debug((Object)("[getSystemMemberApplications] host: " + host));
            }
            catch (Exception e) {
                log.info((Object)"[getSystemMemberApplications] Unable to request cache members.", (Throwable)e);
            }
        }
        return members.toArray(new MemberInfo[0]);
    }

    public Map<ObjectName, String[]> getCacheVmAttributesAsObjectName() {
        ObjectName[] mServers;
        Hashtable<ObjectName, String[]> map = new Hashtable<ObjectName, String[]>();
        for (ObjectName objectName : mServers = this.manageCacheServers()) {
            try {
                MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
                String cwd = (String)mServer.getAttribute(objectName, "workingDirectory");
                String name = (String)mServer.getAttribute(objectName, "name");
                String host = (String)mServer.getAttribute(objectName, "host");
                String[] atts = new String[]{cwd, host, name};
                map.put(objectName, atts);
                log.debug((Object)("[getCacheVmAttributesAsObjectName] id: " + objectName.getCanonicalName()));
                log.debug((Object)("[getCacheVmAttributesAsObjectName] cwd: " + cwd));
                log.debug((Object)("[getCacheVmAttributesAsObjectName] name: " + name));
                log.debug((Object)("[getCacheVmAttributesAsObjectName] host: " + host));
            }
            catch (Exception e) {
                log.debug((Object)("[getCacheVmAttributesAsObjectName] " + e.getMessage()), (Throwable)e);
            }
        }
        return map;
    }

    public int getMemberRoles(String gfid) {
        ObjectName[] stats;
        MBeanServerConnection mServer;
        int mask = 0;
        boolean isPeer = false;
        try {
            mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName peerBean = this.getApplicationObject(gfid);
            String id = (String)mServer.getAttribute(peerBean, "id");
            isPeer = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (isPeer) {
            mask |= 4;
        }
        for (ObjectName objectName : stats = this.getStatObjects(gfid)) {
            try {
                mServer = MxUtil.getMBeanServer((Properties)this.props);
                String type = (String)mServer.getAttribute(objectName, "type");
                if (type.equals("CacheServerStats")) {
                    mask |= 2;
                    continue;
                }
                if (!type.endsWith("GatewayHubStatistics")) continue;
                mask |= 1;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return mask;
    }

    public String[] getStatNames(String gfid) {
        ObjectName[] mStats;
        ArrayList<String> list = new ArrayList<String>();
        for (ObjectName objectName : mStats = this.manageCacheVMStats(gfid)) {
            list.add(objectName.getKeyProperty("name"));
        }
        return list.toArray(new String[0]);
    }

    public ObjectName[] getStatObjects(String gfid) {
        ObjectName[] stats = this.manageCacheVMStats(gfid);
        if (stats == null) {
            stats = this.manageApplicationStats(gfid);
        }
        if (stats == null) {
            stats = new ObjectName[]{};
        }
        return stats;
    }

    public Object[][] getStatObjectsWithType(String gfid) throws PluginException {
        ObjectName[] mStats = this.manageCacheVMStats(gfid);
        if (mStats == null) {
            mStats = this.manageApplicationStats(gfid);
        }
        if (mStats == null) {
            throw new PluginException("Couldn't find statistics. Check that sampling is enabled.");
        }
        Object[][] ret = new Object[mStats.length][2];
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            for (int i = 0; i < mStats.length; ++i) {
                ObjectName objectName = mStats[i];
                String type = (String)mServer.getAttribute(objectName, "type");
                ret[i][0] = objectName;
                ret[i][1] = type;
            }
        }
        catch (Exception e) {
            log.debug((Object)("[getStatObjectsWithType] " + e.getMessage()), (Throwable)e);
        }
        return ret;
    }

    public Map<String, Double> getStatValues(MemberInfo member, String name) {
        return this.getStats(member, name);
    }

    public Map<String, Double> getStatValues(MemberInfo member, String name, String[] keys) {
        return this.getStats(member, name, keys);
    }

    public GFVersionInfo getVersionInfoFromAgent() {
        String vString = this.getAgentVersionString();
        if (vString == null || vString.length() < 3) {
            return null;
        }
        return GFVersionInfo.parse(this.getAgentVersionString());
    }

    public boolean isDistributionAlive() {
        return this.connectToSystem() != null;
    }

    public MBeanServerConnection addAlertNotificationListener(NotificationListener listener) {
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName obj = this.connectToSystem();
            mServer.addNotificationListener(obj, listener, null, null);
            return mServer;
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public void removeAlertNotificationListener(NotificationListener listener) {
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName obj = this.connectToSystem();
            mServer.removeNotificationListener(obj, listener);
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
        }
        catch (InstanceNotFoundException e) {
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }
}

