/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.metric;

import com.vmware.vfabric.hyperic.plugin.vfgf.GFProductPlugin;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberCache;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberInfo;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MetricCache;
import com.vmware.vfabric.hyperic.plugin.vfgf.mx.GFJmxConnection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GFMeasurementPlugin
extends MeasurementPlugin {
    private static final Log log = LogFactory.getLog(GFMeasurementPlugin.class);
    private Map<String, MetricCache> metricCaches;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.metricCaches = new Hashtable<String, MetricCache>();
    }

    protected MetricCache getMetricCache(String id) {
        MetricCache cache = this.metricCaches.get(id);
        if (cache == null) {
            cache = new MetricCache();
            this.metricCaches.put(id, cache);
        }
        return cache;
    }

    protected Map<String, Double> collectStats(Properties props, String[] keys) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got these properties for collection: " + props));
        }
        MemberCache memberCache = ((GFProductPlugin)this.getProductPlugin()).getMemberCache(props.getProperty("jmx.url"));
        String workingDirectory = props.getProperty("workingDirectory");
        String host = props.getProperty("host");
        String name = props.getProperty("name");
        Map<String, Double> map = null;
        try {
            GFJmxConnection gf = new GFJmxConnection(props);
            MemberInfo member = memberCache.getMember(workingDirectory, host, name);
            map = keys.length > 0 ? gf.getStatValues(member, props.getProperty("statname"), keys) : gf.getStatValues(member, props.getProperty("statname"));
        }
        catch (Exception e) {
            log.debug((Object)("Error collecting stats. " + e.getMessage()), (Throwable)e);
        }
        return map;
    }
}

