/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.detector;

import com.vmware.vfabric.hyperic.plugin.vfgf.detector.MemberDetector;
import com.vmware.vfabric.hyperic.plugin.vfgf.util.GFMXUtils;
import com.vmware.vfabric.hyperic.plugin.vfgf.util.GFUtils;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.config.ConfigResponse;

public class CacheServerDetector
extends MemberDetector {
    private static final Log log = LogFactory.getLog(CacheServerDetector.class);

    protected boolean hasCorrectRoles(int mask) {
        log.debug((Object)GFUtils.roleMaskToDebugString(mask));
        return (mask & 2) == 2 && (mask & 1) != 1;
    }

    protected MemberDetector.StatType[] filterSupportedStats(Object[][] statObjects, ConfigResponse config) {
        ArrayList<MemberDetector.StatType> stats = new ArrayList<MemberDetector.StatType>();
        for (int i = 0; i < statObjects.length; ++i) {
            ObjectName o = (ObjectName)statObjects[i][0];
            String type = (String)statObjects[i][1];
            String name = GFMXUtils.getField(o, "name");
            if (name.equals("distributionStats")) {
                stats.add(new MemberDetector.StatType(this, "Distribution Statistics", o));
                continue;
            }
            if (name.equals("statSampler")) {
                stats.add(new MemberDetector.StatType(this, "Statistics Sampler", o));
                continue;
            }
            if (name.startsWith("RegionStats-")) {
                stats.add(new MemberDetector.StatType(this, "Region", o, o.getKeyProperty("name").substring(12)));
                continue;
            }
            if (name.startsWith("cachePerfStats")) {
                stats.add(new MemberDetector.StatType(this, "Cache Performance", o));
                continue;
            }
            if (name.startsWith("Partitioned Region")) {
                stats.add(new MemberDetector.StatType(this, "Partitioned Region", o, o.getKeyProperty("name").substring(19)));
                continue;
            }
            if (type.equals("CacheServerStats") && !name.startsWith("RegionStats-")) {
                stats.add(new MemberDetector.StatType(this, "Cache Server", o, o.getKeyProperty("name")));
                continue;
            }
            if (name.equals("dlockStats")) {
                stats.add(new MemberDetector.StatType(this, "Distributed Lock", o));
                continue;
            }
            if (name.equals("ResourceManagerStats")) {
                stats.add(new MemberDetector.StatType(this, "Resource Manager", o));
                continue;
            }
            if (name.equals("FunctionExecution")) {
                stats.add(new MemberDetector.StatType(this, "Function Service", o));
                continue;
            }
            if (type.equals("FunctionStatistics")) {
                stats.add(new MemberDetector.StatType(this, "Function", o, o.getKeyProperty("name")));
                continue;
            }
            if (name.equals("cacheClientNotifierStats")) {
                stats.add(new MemberDetector.StatType(this, "Cache Client Notifier", o));
                continue;
            }
            if (type.equals("DiskStoreStatistics")) {
                stats.add(new MemberDetector.StatType(this, "Disk Store", o, o.getKeyProperty("name")));
                continue;
            }
            if (type.equals("DiskDirStatistics")) {
                stats.add(new MemberDetector.StatType(this, "Disk Directory", o, o.getKeyProperty("name")));
                continue;
            }
            if (!type.equals("DiskRegionStatistics")) continue;
            stats.add(new MemberDetector.StatType(this, "Disk Region", o, o.getKeyProperty("name")));
        }
        return stats.toArray(new MemberDetector.StatType[0]);
    }
}

