/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;

public class MQSeriesProductPlugin
extends ProductPlugin {
    static boolean traceEnabled = false;
    private static Log log = LogFactory.getLog(MQSeriesProductPlugin.class);
    public static final String SERVER_NAME = "MQSeries";
    public static final String MGR_NAME = "Queue Manager";
    public static final String Q_NAME = "Queue";
    public static final String PROP_Q_NAME = "queue.name";
    public static final String PROP_CLS_NAME = "cluster.name";
    public static String MQ_KEY;
    private static String DSPMQ;
    private static String installPath;
    public static final String INSTALLPATH_PROP = "mqseries.installpath";

    public static boolean isTraceEnabled() {
        return traceEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getRegistryValue(String name) {
        RegistryKey key = null;
        try {
            key = RegistryKey.LocalMachine.openSubKey(MQ_KEY);
            String string = key.getStringValue(name).trim();
            return string;
        }
        catch (Win32Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (key != null) {
                key.close();
            }
        }
    }

    static String getRegistryFilePath() {
        return MQSeriesProductPlugin.getRegistryValue("FilePath");
    }

    public static String getRegistryWorkPath() {
        return MQSeriesProductPlugin.getRegistryValue("WorkPath");
    }

    static String findInstallDir() {
        if (installPath == null) {
            try {
                Sigar sigar = new Sigar();
                long[] pids = ProcessFinder.find((Sigar)sigar, (String)"State.Name.sw=amqzxma0");
                log.debug((Object)("[findInstallDir] pids=" + pids.length));
                for (int i = 0; i < pids.length && installPath == null; ++i) {
                    long pid = pids[i];
                    File exec = new File(sigar.getProcExe(pid).getName());
                    File dspmqver = new File(exec.getParent(), MQSeriesProductPlugin.isWin32() ? "dspmqver.exe" : "dspmqver");
                    log.debug((Object)("[findInstallDir] dspmqver: " + dspmqver));
                    if (!dspmqver.exists()) continue;
                    installPath = dspmqver.getParentFile().getParent();
                }
            }
            catch (SigarException ex) {
                log.debug((Object)("[findInstallDir] ERROR: " + (Object)((Object)ex)), (Throwable)ex);
            }
        }
        return installPath;
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        Properties managerProps = manager.getProperties();
        traceEnabled = "true".equalsIgnoreCase(managerProps.getProperty("mqseries.trace"));
        DSPMQ = managerProps.getProperty("mqseries.dspmq.path");
        log.debug((Object)("mqseries.installpath = " + installPath));
        log.debug((Object)("mqseries.trace = " + traceEnabled));
        log.debug((Object)("mqseries.dspmq.path = " + DSPMQ));
    }

    public String[] getClassPath(ProductPluginManager manager) {
        installPath = manager.getProperties().getProperty(INSTALLPATH_PROP);
        String installDir = MQSeriesProductPlugin.findInstallDir();
        ArrayList<String> classpath = new ArrayList<String>();
        log.debug((Object)("installDir = '" + installDir + "'"));
        if (installDir != null) {
            File mqJar = new File(installDir, "/java/lib/com.ibm.mq.jar");
            if (mqJar.exists()) {
                classpath.add(mqJar.getAbsolutePath());
            } else {
                log.error((Object)(mqJar + " Not Found!!!"));
            }
            String[] pcfJar = new File(installDir, "/java/lib").list(new FilenameFilter(){

                public boolean accept(File arg0, String arg1) {
                    return arg1.toLowerCase().indexOf("pcf") != -1 && arg1.toLowerCase().endsWith("jar");
                }
            });
            if (pcfJar == null) {
                log.error((Object)"No PCF Jar found (see help on the Inventory Properties page)");
            } else if (pcfJar.length != 1) {
                log.error((Object)("No PCF Jar found (see help on the Inventory Properties page) => " + Arrays.asList(pcfJar)));
            } else {
                classpath.add(installDir + "/java/lib/" + pcfJar[0]);
            }
            log.debug((Object)("classpath: " + classpath));
        }
        return classpath.toArray(new String[0]);
    }

    public static String getDspmqComand(String path) {
        if (DSPMQ != null) {
            return DSPMQ;
        }
        return new File(path, "bin/dspmq").getAbsolutePath();
    }
}

