/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.wsmq.track.ChannelEventTracker;
import org.hyperic.hq.plugin.wsmq.track.QueueEventTracker;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.util.config.ConfigResponse;

public class MQSeriesEventsTrack
extends LogTrackPlugin {
    private Log log = LogFactory.getLog(MQSeriesEventsTrack.class);
    private ChannelEventTracker channels;
    private QueueEventTracker queue;

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.log.debug((Object)(" configure(" + config + ")"));
        this.config = config;
        if (this.channels != null) {
            this.channels.setQManager(config.getValue("queue.manager.name"));
            this.queue.setQManager(config.getValue("queue.manager.name"));
        } else {
            this.channels = new ChannelEventTracker(config.getValue("queue.manager.name"), this);
            this.queue = new QueueEventTracker(config.getValue("queue.manager.name"), this);
            this.getManager().addRunnableTracker((Runnable)this.channels);
            this.getManager().addRunnableTracker((Runnable)this.queue);
        }
    }

    public void reportWarnEvent(String org, String mensaje, long time) {
        this.reportEvent(org, mensaje, time, 4);
    }

    public void reportErrorEvent(String org, String mensaje, long time) {
        this.reportEvent(org, mensaje, time, 3);
    }

    public void reportInfoEvent(String org, String mensaje, long time) {
        this.reportEvent(org, mensaje, time, 6);
    }

    public void reportDebugEvent(String org, String mensaje, long time) {
        this.reportEvent(org, mensaje, time, 7);
    }

    private void reportEvent(String org, String mensaje, long time, int level) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getLogLevel()=" + this.getLogLevel() + " >= level=" + level + " == " + (this.getLogLevel() >= level)));
        }
        if (this.getLogLevel() >= level) {
            this.getManager().reportEvent(new TrackEvent(this.getName(), time, level, org, mensaje));
        }
    }
}

