/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.NetServices;
import org.hyperic.sigar.ProcUtil;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.util.config.ConfigResponse;

public class NetServicesDetector
extends ServerDetector
implements AutoServerDetector {
    private static final String RPC = "RPC";

    private ServerResource getServer(ConfigResponse config) {
        ServerResource server = this.createServerResource("/");
        String fqdn = config.getValue("platform.fqdn");
        String type = this.getTypeInfo().getName();
        server.setName(fqdn + " " + type);
        server.setIdentifier(server.getName());
        server.setProductConfig();
        server.setMeasurementConfig();
        this.getLog().debug((Object)("Created server=" + server.getName()));
        return server;
    }

    public List getServerResources(ConfigResponse config) {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        servers.add(this.getServer(config));
        return servers;
    }

    private ServiceResource createService(String type, String address, String port, boolean isSSL) {
        ConfigResponse config = new ConfigResponse();
        config.setValue("hostname", address);
        config.setValue("port", port);
        if (isSSL) {
            config.setValue("ssl", "true");
        }
        ServiceResource service = new ServiceResource();
        service.setType(type);
        String name = NetServicesDetector.getPlatformName() + " " + type;
        if (isSSL) {
            name = name + " (SSL)";
        }
        service.setName(name);
        this.setProductConfig(service, config);
        service.setMeasurementConfig(new ConfigResponse(), 4, false);
        return service;
    }

    private String getDescription(Sigar sigar, long port) {
        long pid = -1L;
        try {
            pid = sigar.getProcPort(16, port);
            if (pid == 0L) {
                return null;
            }
        }
        catch (SigarException e) {
            return null;
        }
        String description = null;
        if (pid != -1L) {
            try {
                description = ProcUtil.getDescription((SigarProxy)sigar, (long)pid);
                int len = description.length() + 4;
                int max = 200 - len;
                if (description.length() > max) {
                    int offset = description.length() - max;
                    description = "..." + description.substring(offset);
                }
            }
            catch (SigarException e) {
                return null;
            }
        }
        if (description == null || description.length() == 0) {
            return null;
        }
        return description;
    }

    private boolean isIPv4(String address) {
        return new StringTokenizer(address, ".", true).countTokens() == 7;
    }

    private void discoverNFS(List services) {
        FileSystem[] fslist;
        if (NetServicesDetector.isWin32()) {
            return;
        }
        try {
            fslist = NetServicesDetector.getSigar().getFileSystemList();
        }
        catch (SigarException e) {
            return;
        }
        for (int i = 0; i < fslist.length; ++i) {
            String dev;
            int ix;
            String type;
            FileSystem fs = fslist[i];
            if (fs.getType() != 3 || !(type = fs.getSysTypeName()).equals("nfs") || (ix = (dev = fs.getDevName()).indexOf(58)) == -1) continue;
            String host = dev.substring(0, ix);
            ServiceResource service = new ServiceResource();
            ConfigResponse config = new ConfigResponse();
            config.setValue("hostname", host);
            config.setValue("program", type);
            config.setValue("version", "2");
            service.setProductConfig(config);
            service.setMeasurementConfig();
            service.setType(RPC);
            String name = NetServicesDetector.getPlatformName() + " NFS mount " + dev;
            service.setName(name);
            service.setDescription("Local mount point: " + fs.getDirName());
            services.add(service);
        }
    }

    private String getDiscover(String type) {
        String key = "netservices.discover";
        if (type != null) {
            key = key + "." + type;
        }
        return this.getManager().getProperty(key);
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        String description;
        ServiceResource service;
        NetConnection[] connections;
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        if (!"false".equals(this.getDiscover(RPC))) {
            this.discoverNFS(services);
        }
        if ("true".equals(this.getDiscover("http"))) {
            services.add(this.createService("HTTP", "localhost", "80", false));
        }
        if (!"true".equals(this.getDiscover(null))) {
            return services;
        }
        String ip = serverConfig.getValue("platform.ip");
        ProductPluginManager ppm = (ProductPluginManager)this.getManager().getParent();
        ProductPlugin pPlugin = ppm.getProductPlugin("netservices");
        Sigar sigar = new Sigar();
        int flags = 18;
        try {
            connections = sigar.getNetConnectionList(flags);
        }
        catch (SigarException e) {
            return null;
        }
        HashMap<String, String> ports = new HashMap<String, String>();
        for (int i = 0; i < connections.length; ++i) {
            String address;
            NetConnection conn = connections[i];
            if (conn.getState() != 10 || (address = conn.getLocalAddress()).equals("::") || !this.isIPv4(address)) continue;
            if (NetFlags.isAnyAddress((String)address)) {
                address = "*";
            }
            ports.put(String.valueOf(conn.getLocalPort()), address);
        }
        TypeInfo[] types = pPlugin.getTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i].getType() != 3) continue;
            String type = types[i].getName();
            MeasurementPlugin plugin = ppm.getMeasurementPlugin(type);
            String[] props = new String[]{"port", "sslport"};
            for (int j = 0; j <= 1; ++j) {
                String port = plugin.getTypeProperty(props[j]);
                if (port == null) continue;
                boolean isSSL = j == 1;
                String address = (String)ports.remove(port);
                if (address == null) continue;
                if (address.equals("*")) {
                    address = ip;
                }
                service = this.createService(type, address, port, isSSL);
                description = this.getDescription(sigar, Long.parseLong(port));
                if (description != null) {
                    service.setDescription(description);
                }
                services.add(service);
            }
        }
        for (Map.Entry entry : ports.entrySet()) {
            String portstr = (String)entry.getKey();
            String address = (String)entry.getValue();
            long port = Long.parseLong(portstr);
            StringBuffer name = new StringBuffer();
            name.append(NetServicesDetector.getPlatformName()).append(" LISTEN ").append(address).append(':').append(port);
            String pname = NetServices.getTcpName((long)port);
            if (pname != null) {
                name.append(" (").append(pname).append(")");
            }
            description = this.getDescription(sigar, port);
            if (pname == null && description == null) continue;
            if (address.equals("*")) {
                address = ip;
            }
            service = this.createService("TCP Socket", address, portstr, false);
            service.setName(name.toString());
            service.setDescription(description);
            services.add(service);
        }
        return services;
    }
}

