/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.io.IOException;
import java.net.PortUnreachableException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hyperic.hq.plugin.netservices.NetServicesCollector;
import org.hyperic.hq.product.PluginException;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.Type;

public class DNSCollector
extends NetServicesCollector {
    private Message query;
    private String lookupName;
    private String nameserver;
    private Pattern pattern;
    private boolean isMatchAny = false;
    private int type = 1;

    private SimpleResolver getResolver() throws UnknownHostException {
        String ip = this.getHostname();
        if (ip == null) {
            ip = ResolverConfig.getCurrentConfig().server();
        }
        SimpleResolver resolver = new SimpleResolver(ip);
        resolver.setPort(this.getPort());
        resolver.setTimeout(this.getTimeout());
        this.nameserver = ip;
        this.setSource(this.nameserver + ":" + this.getPort() + "/" + this.lookupName);
        return resolver;
    }

    protected void init() throws PluginException {
        super.init();
        Properties props = this.getProperties();
        try {
            String recordType;
            this.lookupName = props.getProperty("lookupname");
            String pattern = props.getProperty("pattern");
            if (pattern != null) {
                if (pattern.equals("*")) {
                    pattern = ".*";
                    this.isMatchAny = true;
                }
                try {
                    this.pattern = Pattern.compile(pattern);
                }
                catch (PatternSyntaxException e) {
                    throw new PluginException(pattern + ": " + e);
                }
            }
            if ((recordType = props.getProperty("type")) != null) {
                this.type = Type.value((String)recordType);
                if (this.type == -1) {
                    throw new PluginException("Invalid record type: " + recordType);
                }
            }
            Name name = Name.fromString((String)this.lookupName, (Name)Name.root);
            Record record = Record.newRecord((Name)name, (int)this.type, (int)1);
            this.query = Message.newQuery((Record)record);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }

    public void collect() {
        String errmsg;
        block14: {
            try {
                this.startTime();
                Message message = this.getResolver().send(this.query);
                this.endTime();
                double avail = 1.0;
                Record[] answers = message.getSectionArray(1);
                Record[] authority = message.getSectionArray(2);
                Record[] additional = message.getSectionArray(3);
                this.setValue("Answers", answers.length);
                this.setValue("AuthorityRecords", authority.length);
                this.setValue("AdditionalRecords", additional.length);
                boolean matchRequired = this.pattern != null;
                boolean matched = false;
                if (answers.length == 0) {
                    String msg = this.nameserver + " can't find " + this.lookupName;
                    if (matchRequired) {
                        this.setErrorMessage(msg);
                        avail = 0.5;
                    } else {
                        this.setWarningMessage(msg);
                    }
                } else {
                    ArrayList<String> rdata = null;
                    String msg = "Non-authoritative answer: '" + answers[0].rdataToString() + "'";
                    if (this.pattern == null || this.isMatchAny) {
                        matched = true;
                    } else {
                        rdata = new ArrayList<String>();
                        for (int i = 0; i < answers.length; ++i) {
                            String data = answers[i].rdataToString();
                            rdata.add(data);
                            matched = this.pattern.matcher(data).find();
                            if (matched) break;
                        }
                    }
                    if (matchRequired && !matched) {
                        avail = 0.5;
                        if (answers.length > 1) {
                            msg = "answers: " + ((Object)rdata).toString();
                        }
                        this.setErrorMessage(msg + " invalid, expecting: '" + this.pattern.pattern() + "'");
                    } else {
                        this.setInfoMessage(msg);
                    }
                }
                this.setAvailability(avail);
                return;
            }
            catch (PortUnreachableException e) {
                errmsg = this.nameserver + " port unreachable";
            }
            catch (SocketTimeoutException e) {
                errmsg = this.nameserver + " socket timeout";
            }
            catch (IOException e) {
                errmsg = e.getMessage();
                if (errmsg != null) break block14;
                errmsg = e.toString();
            }
        }
        this.setErrorMessage(errmsg);
        this.setAvailability(false);
    }
}

