/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Random;
import java.util.StringTokenizer;

public class DHCPClient {
    private static final Random random = new Random();
    private static final int MESSAGE_TYPE = 53;
    private int port;
    private InetAddress address;
    private DatagramSocket socket = new DatagramSocket(68);

    public DHCPClient(InetAddress address, int port) throws SocketException {
        this.address = address;
        this.port = port;
    }

    public void setTimeout(int millis) {
        try {
            this.socket.setSoTimeout(millis);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.socket.close();
    }

    public void send(Packet packet) throws IOException {
        byte[] data = packet.encode();
        DatagramPacket request = new DatagramPacket(data, data.length, this.address, this.port);
        this.socket.send(request);
    }

    public Packet receive() throws IOException {
        byte[] data = new byte[1024];
        DatagramPacket response = new DatagramPacket(data, data.length);
        this.socket.receive(response);
        Packet packet = new Packet();
        packet.decode(response.getData());
        return packet;
    }

    private static String addrToText(byte[] src) {
        return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
    }

    public static byte[] decodeHwaddr(String hwaddr) {
        StringTokenizer token = new StringTokenizer(hwaddr, ":");
        byte[] data = new byte[16];
        for (int i = 0; i < 6; ++i) {
            data[i] = (byte)Integer.parseInt(token.nextToken(), 16);
        }
        return data;
    }

    public Packet getDiscoverPacket(byte[] hwaddr) {
        Packet packet = new Packet();
        packet.xid = random.nextInt();
        packet.chaddr = hwaddr;
        byte[] options = packet.options;
        int ix = 0;
        options[ix++] = 99;
        options[ix++] = -126;
        options[ix++] = 83;
        options[ix++] = 99;
        options[ix++] = 53;
        options[ix++] = 1;
        options[ix++] = 1;
        options[ix++] = -1;
        return packet;
    }

    public class Packet {
        private static final int ADDR_LEN = 4;
        private static final int CHADDR_LEN = 16;
        private static final int SNAME_LEN = 64;
        private static final int FILE_LEN = 128;
        private static final int OPTIONS_LEN = 312;
        private static final int HWADDR_LEN = 6;
        public byte op = 1;
        public byte htype = 1;
        public byte hlen = (byte)6;
        public byte hops = 0;
        public int xid;
        public short secs = 0;
        public short flags = 0;
        public byte[] ciaddr = new byte[4];
        public byte[] yiaddr = new byte[4];
        public byte[] siaddr = new byte[4];
        public byte[] giaddr = new byte[4];
        public byte[] chaddr = new byte[16];
        public byte[] sname = new byte[64];
        public byte[] file = new byte[128];
        public byte[] options = new byte[312];

        public String getYaddress() {
            return DHCPClient.addrToText(this.yiaddr);
        }

        public String getSaddress() {
            return DHCPClient.addrToText(this.siaddr);
        }

        public byte[] encode() throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bytes);
            stream.writeByte(this.op);
            stream.writeByte(this.htype);
            stream.writeByte(this.hlen);
            stream.writeByte(this.hops);
            stream.writeInt(this.xid);
            stream.writeShort(this.secs);
            stream.writeShort(this.flags);
            stream.write(this.ciaddr, 0, 4);
            stream.write(this.yiaddr, 0, 4);
            stream.write(this.siaddr, 0, 4);
            stream.write(this.giaddr, 0, 4);
            stream.write(this.chaddr, 0, 16);
            stream.write(this.sname, 0, 64);
            stream.write(this.file, 0, 128);
            stream.write(this.options, 0, 312);
            return bytes.toByteArray();
        }

        public void decode(byte[] data) throws IOException {
            ByteArrayInputStream bytes = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream stream = new DataInputStream(bytes);
            this.op = stream.readByte();
            this.htype = stream.readByte();
            this.hlen = stream.readByte();
            this.hops = stream.readByte();
            this.xid = stream.readInt();
            this.secs = stream.readShort();
            this.flags = stream.readShort();
            stream.readFully(this.ciaddr, 0, 4);
            stream.readFully(this.yiaddr, 0, 4);
            stream.readFully(this.siaddr, 0, 4);
            stream.readFully(this.giaddr, 0, 4);
            stream.readFully(this.chaddr, 0, 16);
            stream.readFully(this.sname, 0, 64);
            stream.readFully(this.file, 0, 128);
            stream.readFully(this.options, 0, 312);
        }
    }
}

