/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.versioncontrol.dto;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.hyperic.cm.versioncontrol.dto.ChangeTypeDto;
import org.hyperic.cm.versioncontrol.jgit.FileDiff;

public class RevisionDiffItem {
    private Date commitTime;
    private String path;
    private String id;
    private String prevVersionId;
    private String revisionId;
    private ChangeTypeDto changeType;
    private String comment;
    private Integer fileModeBits;
    private Integer prevVersionFileModeBits;
    public static final String DATE_FORMAT = "MM/dd/yyyy hh:mm:ss";

    public RevisionDiffItem() {
    }

    public RevisionDiffItem(FileDiff fileDiff) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(fileDiff.getCommit().getCommitTime());
        this.commitTime = c.getTime();
        this.path = fileDiff.getPath();
        ObjectId[] objIds = fileDiff.getBlobs();
        if (objIds != null && objIds.length > 0) {
            this.id = ObjectId.toString((ObjectId)fileDiff.getBlobs()[objIds.length - 1]);
        }
        if (objIds != null && objIds.length > 1) {
            this.prevVersionId = ObjectId.toString((ObjectId)fileDiff.getBlobs()[0]);
        }
        this.revisionId = ObjectId.toString((ObjectId)fileDiff.getCommit().getId());
        this.changeType = ChangeTypeDto.fromChangeType(fileDiff.getChange(), false);
        FileMode[] fileModes = fileDiff.getModes();
        if (fileModes != null && fileModes.length > 0) {
            this.fileModeBits = fileDiff.getModes()[fileModes.length - 1].getBits();
        }
        if (fileModes != null && fileModes.length > 1) {
            this.prevVersionFileModeBits = fileDiff.getModes()[0].getBits();
        }
    }

    public Date getCommitTime() {
        return this.commitTime;
    }

    public void setCommitTime(Date date) {
        this.commitTime = date;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ChangeTypeDto getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeTypeDto changeType) {
        this.changeType = changeType;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public void setFileModeBits(Integer fileModeBits) {
        this.fileModeBits = fileModeBits;
    }

    public Integer getFileModeBits() {
        return this.fileModeBits;
    }

    public String getPrevVersionId() {
        return this.prevVersionId;
    }

    public void setPrevVersionId(String prevVersionId) {
        this.prevVersionId = prevVersionId;
    }

    public Integer getPrevVersionFileModeBits() {
        return this.prevVersionFileModeBits;
    }

    public void setPrevVersionFileModeBits(Integer prevFileModeBits) {
        this.prevVersionFileModeBits = prevFileModeBits;
    }
}

