/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.multilogtrack;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.DirectoryScanner;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLogTrackServerDetector
extends ServerDetector {
    private static final Log log = LogFactory.getLog(MultiLogTrackServerDetector.class);
    private static final String SERVER_NAME = "Multi Log Tracker";
    private static final String SERVER_TYPE = "MultiLogTracker 1.0";
    private static final String LOG_FILE_TRACKER_TYPE = "LogFileTracker";
    static final String ENABLE_LOG_SERVICES_PROP = "server.enable_log_services";
    static final String ENABLE_ONLY_METRICS = "enable_only_metrics";
    public static final String OVERRIDE_CHECKS = "override_file_checks";
    private static final Map<String, List<String>> files = new HashMap<String, List<String>>();

    public List<ServerResource> getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> rtn = new ArrayList<ServerResource>();
        ConfigResponse productConfig = new ConfigResponse();
        String serverName = this.getFqdn(productConfig) + " " + SERVER_NAME;
        ServerResource server = this.newServerResource("/tmp", SERVER_TYPE, serverName, productConfig);
        rtn.add(server);
        return rtn;
    }

    private String getFqdn(ConfigResponse config) {
        return config.getValue("platform.fqdn", MultiLogTrackServerDetector.getPlatformName());
    }

    private ServerResource newServerResource(String installdir, String type, String name, ConfigResponse productConfig) {
        ServerResource server = this.createServerResource(installdir);
        this.setProductConfig(server, productConfig);
        this.setMeasurementConfig(server, new ConfigResponse());
        server.setName(name);
        server.setType(type);
        return server;
    }

    protected List<ServiceResource> discoverServices(ConfigResponse config) throws PluginException {
        if ("true".equals(config.getValue(ENABLE_LOG_SERVICES_PROP, "true"))) {
            return this.getServices(config);
        }
        return Collections.emptyList();
    }

    private List<ServiceResource> getServices(ConfigResponse serverConfig) throws PluginException {
        ArrayList<ServiceResource> rtn = new ArrayList<ServiceResource>();
        ArrayList<String> files = new ArrayList<String>();
        String basedir = MultiLogTrackServerDetector.getBasedirAndSetFiles(serverConfig, files);
        String value = serverConfig.getValue("server.log_track.enable");
        boolean serverHasLogTrack = value != null && value.equalsIgnoreCase("true");
        for (String file : files) {
            ConfigResponse serviceConfig = new ConfigResponse();
            ConfigResponse logConfig = new ConfigResponse();
            if (serverHasLogTrack) {
                logConfig.setValue("service.log_track.enable", "false");
            } else {
                logConfig.setValue("service.log_track.enable", "true");
            }
            String logfile = basedir + MultiLogTrackServerDetector.getFileSeparator(basedir) + file;
            serviceConfig.setValue("logfile", logfile);
            rtn.add(this.newServiceResource(logConfig, logfile, serviceConfig));
        }
        return rtn;
    }

    static String getFileSeparator(String exampleDir) {
        if (exampleDir == null) {
            return File.separator;
        }
        if (exampleDir.contains("\\")) {
            return "\\";
        }
        if (exampleDir.contains("/")) {
            return "/";
        }
        return File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean fileCacheIsSet(ConfigResponse cfg) {
        Map<String, List<String>> map = files;
        synchronized (map) {
            String logfilepattern = MultiLogTrackServerDetector.getLogfilepattern(cfg);
            String basedir = MultiLogTrackServerDetector.getBasedir(cfg);
            String key = logfilepattern + "|" + basedir;
            return files.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> getFilesCached(String logfilepattern, String basedir, String includePattern, boolean resetCache) {
        Map<String, List<String>> map = files;
        synchronized (map) {
            List<String> tmp;
            String key = logfilepattern + "|" + basedir + "|" + includePattern;
            if (resetCache) {
                files.remove(key);
            }
            if (null == (tmp = files.get(key))) {
                tmp = MultiLogTrackServerDetector.getFiles(logfilepattern, basedir);
                files.put(key, tmp);
            }
            return files.get(key);
        }
    }

    private static List<String> getFiles(String logfilepattern, String basedir) {
        if (logfilepattern == null || basedir == null) {
            return Collections.emptyList();
        }
        File dir = new File(basedir);
        if (!dir.isDirectory()) {
            log.debug((Object)("basedir=" + dir + " is not a directory"), new Throwable());
            return Collections.emptyList();
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(basedir);
        String[] toks = logfilepattern.split(",");
        ArrayList<String> filePatterns = new ArrayList<String>(toks.length);
        for (String tok : toks) {
            while (tok.startsWith("/") || tok.startsWith("\\")) {
                tok = tok.substring(1, tok.length());
            }
            filePatterns.add(tok);
        }
        scanner.setIncludes(filePatterns.toArray(new String[0]));
        scanner.scan();
        return Arrays.asList(scanner.getIncludedFiles());
    }

    static String getBasedir(ConfigResponse config) {
        String basedir = config.getValue("basedir", "").trim();
        return MultiLogTrackServerDetector.getBasedir(basedir);
    }

    static String getBasedir(String basedir) {
        String string = basedir = basedir == null ? "" : basedir.trim();
        while (basedir.endsWith("/") || basedir.endsWith("\\")) {
            basedir = basedir.substring(0, basedir.length() - 1);
        }
        return basedir;
    }

    static String getLogfilepattern(ConfigResponse config) {
        return config.getValue("logfilepattern", "").trim();
    }

    static String getBasedirAndSetFilesFromCache(ConfigResponse config, Collection<String> files, boolean resetCache) {
        String logfilepattern = MultiLogTrackServerDetector.getLogfilepattern(config);
        String basedir = MultiLogTrackServerDetector.getBasedir(config);
        String includePattern = config.getValue("includepattern", "");
        files.addAll(MultiLogTrackServerDetector.getFilesCached(logfilepattern, basedir, includePattern, resetCache));
        return basedir;
    }

    private static String getBasedirAndSetFiles(ConfigResponse config, Collection<String> files) {
        String logfilepattern = MultiLogTrackServerDetector.getLogfilepattern(config);
        String basedir = MultiLogTrackServerDetector.getBasedir(config);
        files.addAll(MultiLogTrackServerDetector.getFiles(logfilepattern, basedir));
        return basedir;
    }

    private ServiceResource newServiceResource(ConfigResponse logConfig, String name, ConfigResponse productConfig) {
        ServiceResource service = new ServiceResource();
        service.setType((GenericPlugin)this, LOG_FILE_TRACKER_TYPE);
        service.setServiceName(name);
        service.setProductConfig(productConfig);
        service.setMeasurementConfig(logConfig);
        return service;
    }
}

