/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutCommand
extends GitCommand<Ref> {
    private String name;
    private boolean force = false;
    private boolean createBranch = false;
    private CreateBranchCommand.SetupUpstreamMode upstreamMode;
    private String startPoint = null;
    private RevCommit startCommit;
    private CheckoutResult status;
    private List<String> paths = new LinkedList<String>();

    protected CheckoutCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws JGitInternalException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException {
        this.checkCallable();
        this.processOptions();
        try {
            RefUpdate.Result updateResult;
            if (!this.paths.isEmpty()) {
                this.checkoutPaths();
                this.status = CheckoutResult.OK_RESULT;
                this.setCallable(false);
                Ref ref = null;
                return ref;
            }
            if (this.createBranch) {
                Git git = new Git(this.repo);
                CreateBranchCommand command = git.branchCreate();
                command.setName(this.name);
                command.setStartPoint(this.getStartPoint().name());
                if (this.upstreamMode != null) {
                    command.setUpstreamMode(this.upstreamMode);
                }
                command.call();
            }
            Ref headRef = this.repo.getRef("HEAD");
            String refLogMessage = "checkout: moving from " + headRef.getTarget().getName();
            ObjectId branch = this.repo.resolve(this.name);
            if (branch == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.name));
            }
            RevWalk revWalk = new RevWalk(this.repo);
            ObjectId headId = headRef.getObjectId();
            RevCommit headCommit = headId == null ? null : revWalk.parseCommit(headId);
            RevCommit newCommit = revWalk.parseCommit(branch);
            RevTree headTree = headCommit == null ? null : headCommit.getTree();
            DirCacheCheckout dco = new DirCacheCheckout(this.repo, headTree, this.repo.lockDirCache(), newCommit.getTree());
            dco.setFailOnConflict(true);
            try {
                dco.checkout();
            }
            catch (CheckoutConflictException e) {
                this.status = new CheckoutResult(CheckoutResult.Status.CONFLICTS, dco.getConflicts());
                throw e;
            }
            Ref ref = this.repo.getRef(this.name);
            if (ref != null && !ref.getName().startsWith("refs/heads/")) {
                ref = null;
            }
            RefUpdate refUpdate = this.repo.updateRef("HEAD", ref == null);
            refUpdate.setForceUpdate(this.force);
            refUpdate.setRefLogMessage(refLogMessage + " to " + newCommit.getName(), false);
            if (ref != null) {
                updateResult = refUpdate.link(ref.getName());
            } else {
                refUpdate.setNewObjectId(newCommit);
                updateResult = refUpdate.forceUpdate();
            }
            this.setCallable(false);
            boolean ok = false;
            switch (updateResult) {
                case NEW: {
                    ok = true;
                    break;
                }
                case NO_CHANGE: 
                case FAST_FORWARD: 
                case FORCED: {
                    ok = true;
                    break;
                }
            }
            if (!ok) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutUnexpectedResult, updateResult.name()));
            }
            this.status = !dco.getToBeDeleted().isEmpty() ? new CheckoutResult(CheckoutResult.Status.NONDELETED, dco.getToBeDeleted()) : CheckoutResult.OK_RESULT;
            Ref ref2 = ref;
            return ref2;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
        finally {
            if (this.status == null) {
                this.status = CheckoutResult.ERROR_RESULT;
            }
        }
    }

    public CheckoutCommand addPath(String path) {
        this.checkCallable();
        this.paths.add(path);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckoutCommand checkoutPaths() throws IOException, RefNotFoundException {
        RevWalk revWalk = new RevWalk(this.repo);
        DirCache dc = this.repo.lockDirCache();
        try {
            TreeWalk treeWalk = new TreeWalk(revWalk.getObjectReader());
            treeWalk.setRecursive(true);
            treeWalk.addTree(new DirCacheIterator(dc));
            treeWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
            LinkedList<String> files = new LinkedList<String>();
            while (treeWalk.next()) {
                files.add(treeWalk.getPathString());
            }
            if (this.startCommit != null || this.startPoint != null) {
                DirCacheEditor editor = dc.editor();
                TreeWalk startWalk = new TreeWalk(revWalk.getObjectReader());
                startWalk.setRecursive(true);
                startWalk.setFilter(treeWalk.getFilter());
                startWalk.addTree(revWalk.parseCommit(this.getStartPoint()).getTree());
                while (startWalk.next()) {
                    final ObjectId blobId = startWalk.getObjectId(0);
                    editor.add(new DirCacheEditor.PathEdit(startWalk.getPathString()){

                        public void apply(DirCacheEntry ent) {
                            ent.setObjectId(blobId);
                        }
                    });
                }
                editor.commit();
            }
            File workTree = this.repo.getWorkTree();
            for (String file : files) {
                DirCacheCheckout.checkoutEntry(this.repo, new File(workTree, file), dc.getEntry(file));
            }
        }
        finally {
            dc.unlock();
            revWalk.release();
        }
        return this;
    }

    private ObjectId getStartPoint() throws AmbiguousObjectException, RefNotFoundException, IOException {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        ObjectId result = null;
        result = this.repo.resolve(this.startPoint == null ? "HEAD" : this.startPoint);
        if (result == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.startPoint != null ? this.startPoint : "HEAD"));
        }
        return result;
    }

    private void processOptions() throws InvalidRefNameException {
        if (this.paths.isEmpty() && (this.name == null || !Repository.isValidRefName("refs/heads/" + this.name))) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
    }

    public CheckoutCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public CheckoutCommand setCreateBranch(boolean createBranch) {
        this.checkCallable();
        this.createBranch = createBranch;
        return this;
    }

    public CheckoutCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public CheckoutCommand setStartPoint(String startPoint) {
        this.checkCallable();
        this.startPoint = startPoint;
        this.startCommit = null;
        return this;
    }

    public CheckoutCommand setStartPoint(RevCommit startCommit) {
        this.checkCallable();
        this.startCommit = startCommit;
        this.startPoint = null;
        return this;
    }

    public CheckoutCommand setUpstreamMode(CreateBranchCommand.SetupUpstreamMode mode) {
        this.checkCallable();
        this.upstreamMode = mode;
        return this;
    }

    public CheckoutResult getResult() {
        if (this.status == null) {
            return CheckoutResult.NOT_TRIED_RESULT;
        }
        return this.status;
    }
}

