/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.dotnet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotNetDetector
extends ServerDetector
implements AutoServerDetector {
    private static final String[][] aspAppServices = new String[][]{{"Application", ".NET CLR Loading", "false", ""}, {"ASP.NET App", "ASP.NET Applications", "true", ""}, {"ASP.NET App", "ASP.NET Apps v4.0.30319", "true", "V4 "}, {"ASP.NET App", "ASP.NET Apps v2.0.50727", "true", "V2 "}};
    static final String PROP_APP = "app.name";
    static final String PROP_PATH = "app.path";
    private static final String REG_KEY = "SOFTWARE\\Microsoft\\.NETFramework";
    private static Log log = LogFactory.getLog((String)DotNetDetector.class.getName());
    protected static final String ORACLE_PROVIDER_STR = "Oracle Data Provider for .NET";
    protected static final String SQL_SERVER_PROVIDER_STR = ".NET Data Provider for SqlServer";
    protected static final String SQL_SERVER_PROVIDER_TYPE_STR = "Data Provider for SqlServer";
    protected static final String ORACLE_SERVER_PROVIDER_TYPE_STR = "Oracle Data Provider for .Net";

    private RegistryKey getRegistryKey(String path) throws Win32Exception {
        return RegistryKey.LocalMachine.openSubKey(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        RegistryKey key = null;
        ArrayList<String> versions = new ArrayList<String>();
        Pattern regex = Pattern.compile("v(\\d*\\.\\d*).*");
        try {
            key = this.getRegistryKey("SOFTWARE\\Microsoft\\NET Framework Setup\\NDP");
            String[] names = key.getSubKeyNames();
            for (int i = 0; i < names.length; ++i) {
                log.debug((Object)("[getVersion] names[" + i + "]->" + names[i]));
                Matcher m = regex.matcher(names[i] + ".0");
                if (!m.find()) continue;
                versions.add(m.group(1));
            }
        }
        catch (Win32Exception e) {
            log.debug((Object)e, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (key != null) {
                key.close();
            }
        }
        int size = versions.size();
        if (size == 0) {
            return null;
        }
        Collections.sort(versions);
        log.debug((Object)("Found .NET versions=" + versions));
        return (String)versions.get(size - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInstallPath() {
        RegistryKey key = null;
        try {
            key = this.getRegistryKey(REG_KEY);
            String string = key.getStringValue("InstallRoot").trim();
            return string;
        }
        catch (Win32Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (key != null) {
                key.close();
            }
        }
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        String expectedVersion = this.getTypeInfo().getVersion();
        String version = this.getVersion();
        if (version == null) {
            return null;
        }
        String path = this.getInstallPath();
        boolean valid = version.startsWith(expectedVersion) && path != null;
        log.debug((Object)("Found .NET version=" + version + " (expectedVersion=" + expectedVersion + "), path=" + path + ", valid=" + valid));
        if (!valid) {
            return null;
        }
        ServerResource server = this.createServerResource(path);
        server.setProductConfig();
        server.setMeasurementConfig();
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        servers.add(server);
        return servers;
    }

    private Collection<ServiceResource> addDataProvidersServices(String dataProviderStr, String dataProviderTypeStr) {
        try {
            String[] instances = Pdh.getInstances((String)dataProviderStr);
            Pattern regex = Pattern.compile("([^\\[]*).*");
            HashSet<String> names = new HashSet<String>();
            for (int i = 0; i < instances.length; ++i) {
                String instance = instances[i];
                Matcher m = regex.matcher(instance);
                if (m.find()) {
                    String n = m.group(1).trim();
                    log.debug((Object)("[discoverServices] instance = " + instance + " (" + n + ")"));
                    if (n.length() <= 0) continue;
                    log.debug((Object)("[discoverServices] instance = " + instance + " (" + n + ") valid."));
                    names.add(n);
                    continue;
                }
                log.debug((Object)("[discoverServices] instance = " + instance + " skiped."));
            }
            ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
            for (String name : names) {
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, dataProviderTypeStr);
                service.setServiceName(dataProviderTypeStr + " " + name);
                ConfigResponse pc = new ConfigResponse();
                pc.setValue(PROP_APP, name);
                service.setProductConfig(pc);
                service.setMeasurementConfig();
                services.add(service);
            }
            return services;
        }
        catch (Win32Exception e) {
            log.debug((Object)("Error getting pdh data for '.NET Data Provider for:" + dataProviderStr + ":" + (Object)((Object)e)), (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        services.addAll(this.addDataProvidersServices(SQL_SERVER_PROVIDER_STR, SQL_SERVER_PROVIDER_TYPE_STR));
        services.addAll(this.addDataProvidersServices(ORACLE_PROVIDER_STR, ORACLE_SERVER_PROVIDER_TYPE_STR));
        String instancesToSkipStr = this.getProperties().getProperty("dotnet.instances.to.skip", "_Global_");
        List<String> instancesToSkip = Arrays.asList(instancesToSkipStr.toUpperCase().split(","));
        log.debug((Object)("dotnet.instances.to.skip = " + instancesToSkip));
        for (int i = 0; i < aspAppServices.length; ++i) {
            String serviceType = aspAppServices[i][0];
            String counterName = aspAppServices[i][1];
            boolean useServiceType = aspAppServices[i][2].equals("true");
            try {
                String[] apps = Pdh.getInstances((String)counterName);
                for (int idx = 0; idx < apps.length; ++idx) {
                    String name = apps[idx];
                    if (!instancesToSkip.contains(name.toUpperCase())) {
                        log.debug((Object)("instace '" + name + "' (" + counterName + ") valid."));
                        ServiceResource service = new ServiceResource();
                        service.setType((GenericPlugin)this, serviceType);
                        if (useServiceType) {
                            service.setServiceName(serviceType + " " + aspAppServices[i][3] + name);
                        } else {
                            service.setServiceName(name);
                        }
                        ConfigResponse pc = new ConfigResponse();
                        pc.setValue(PROP_APP, name);
                        pc.setValue(PROP_PATH, counterName);
                        service.setProductConfig(pc);
                        service.setMeasurementConfig();
                        services.add(service);
                        continue;
                    }
                    log.debug((Object)("instace '" + name + "' (" + counterName + ") skiped."));
                }
                continue;
            }
            catch (Win32Exception e) {
                log.debug((Object)("Error getting pdh data for '" + serviceType + "': " + (Object)((Object)e)), (Throwable)e);
            }
        }
        return services;
    }
}

