/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfws;

import com.vmware.vfabric.hyperic.plugin.vfws.BmxQuery;
import com.vmware.vfabric.hyperic.plugin.vfws.BmxResult;
import com.vmware.vfabric.hyperic.plugin.vfws.Listen;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.DaemonDetector;
import org.hyperic.hq.product.FileServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VfwsServerDetector
extends DaemonDetector
implements AutoServerDetector,
FileServerDetector {
    private static final String _logCtx = VfwsServerDetector.class.getName();
    private static final Log _log = LogFactory.getLog((String)_logCtx);
    private static final String ARG_ROOTDIR = "-d";
    private static final String RESOURCE_TYPE = "vFabric Web Server";
    private static final String DEFAULT_BMX_PROTO = "http";
    private static final String DEFAULT_BMX_HOST = "localhost";
    private static final int DEFAULT_BMX_PORT = 80;
    private static final String DEFAULT_BMX_PATH = "/bmx";
    private static final String QUERY_BMX = "?query=";
    private static final String SERVER_STATUS = "mod_bmx_status:Name=ServerStatus";
    private static final String VHOST_QUERY = "mod_bmx_vhost:";
    private static final String VHOST_SERVICE_TYPE = "Virtual Host";
    private static final String HTTPD_CONF = "/conf/httpd.conf";
    private static final String CONF_DIRECTIVE_LISTEN = "LISTEN";
    private static final String CONF_DIRECTIVE_INCLUDE = "INCLUDE";
    private static final List<String> _ptqlQueries = new ArrayList<String>();

    public List<ServerResource> getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.setPlatformConfig(platformConfig);
        ArrayList<ServerResource> servers = new ArrayList();
        servers = this.getServers(this.getPtqlQueries());
        return servers;
    }

    private List<ServerResource> getServers(List<String> ptqlQueries) {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        for (String ptql : ptqlQueries) {
            long[] pids = VfwsServerDetector.getPids((String)ptql);
            if (null == pids || pids.length <= 0) continue;
            for (int i = 0; i < pids.length; ++i) {
                Long pid = pids[i];
                String installPath = this.getInstallPath(pid);
                if (null == installPath) {
                    _log.debug((Object)("Found pid " + pid + ", but couldn't identify installpath"));
                    continue;
                }
                URL bmxUrl = this.findBmxUrl(installPath, HTTPD_CONF);
                if (bmxUrl == null) {
                    _log.debug((Object)("Parsing " + installPath + HTTPD_CONF + " failed to find " + "usable Listen directive."));
                    continue;
                }
                URL bmxQueryUrl = this.getBmxQueryUrl(bmxUrl, "?query=mod_bmx_status:Name=ServerStatus");
                BmxQuery query = new BmxQuery(bmxQueryUrl);
                BmxResult result = query.getResult();
                try {
                    result.parseToProperties();
                }
                catch (IOException e) {
                    _log.debug((Object)"Unable to parse results", (Throwable)e);
                    continue;
                }
                Properties serverStatus = result.getProperties();
                ServerResource server = this.createServerResource(installPath);
                ConfigResponse cprop = new ConfigResponse();
                String version = this.getVersion((String)serverStatus.get("ServerVersion"));
                if (!version.equals(this.getTypeInfo().getVersion())) continue;
                cprop.setValue("version", version);
                cprop.setValue("ServerVersion", (String)serverStatus.get("ServerVersion"));
                server.setCustomProperties(cprop);
                ConfigResponse productConfig = new ConfigResponse();
                productConfig.setValue("process.query", this.getProcessQuery(ptql, installPath));
                productConfig.setValue("protocol", bmxUrl.getProtocol());
                productConfig.setValue("port", bmxUrl.getPort());
                productConfig.setValue("hostname", bmxUrl.getHost());
                productConfig.setValue("path", bmxUrl.getPath() + QUERY_BMX + SERVER_STATUS);
                this.setProductConfig(server, productConfig);
                this.setMeasurementConfig(server, new ConfigResponse());
                String instanceName = this.getInstanceName(installPath);
                server.setName(VfwsServerDetector.getPlatformName() + " " + RESOURCE_TYPE + " " + version + " " + instanceName);
                servers.add(server);
            }
        }
        return servers;
    }

    private String getVersion(String versionString) {
        String[] ent = versionString.split(" ");
        for (int i = 0; i < ent.length; ++i) {
            if (!ent[i].contains("vFabric/")) continue;
            return ent[i].split("/")[1].substring(0, 3);
        }
        return null;
    }

    private URL getBmxQueryUrl(URL url, String path) {
        try {
            URL newUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath() + path);
            return newUrl;
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        try {
            String proto = config.getValue("protocol");
            String hostname = config.getValue("hostname");
            int port = Integer.parseInt(config.getValue("port"));
            String path = "/bmx?query=mod_bmx_vhost:*";
            URL bmxUrl = new URL(proto, hostname, port, path);
            BmxQuery query = new BmxQuery(bmxUrl);
            BmxResult result = query.getResult();
            List<String> names = result.parseForNames();
            for (String name : names) {
                String type = this.getTypeInfo().getName() + " " + VHOST_SERVICE_TYPE;
                ServiceResource service = new ServiceResource();
                String[] ent = name.split(",");
                if (!ent[0].equals("Type=since-start")) continue;
                String host = ent[1].split("=")[1];
                String servicePort = ent[2].split("=")[1];
                path = "/bmx?query=mod_bmx_vhost:" + name;
                ConfigResponse cprops = new ConfigResponse();
                cprops.setValue("protocol", proto);
                cprops.setValue("hostname", hostname);
                cprops.setValue("port", port);
                cprops.setValue("path", path);
                service.setProductConfig(cprops);
                service.setMeasurementConfig();
                service.setType(type);
                service.setServiceName(host + ":" + servicePort);
                services.add(service);
            }
        }
        catch (Exception e) {
            _log.debug((Object)("Exception" + e), (Throwable)e);
            return null;
        }
        return services;
    }

    private String getInstanceName(String installPath) {
        File name = new File(installPath);
        return name.getName();
    }

    private String getProcessQuery(String ptql, String installPath) {
        return ptql + ",Args.*.eq=" + ARG_ROOTDIR + ",Args.*.eq=" + installPath;
    }

    private URL findBmxUrl(String installPath, String filename) {
        URL url = null;
        String proto = DEFAULT_BMX_PROTO;
        String host = DEFAULT_BMX_HOST;
        int port = 80;
        String path = DEFAULT_BMX_PATH;
        List<Listen> listens = this.getListens(installPath, filename);
        for (Listen listen : listens) {
            if (listen.getPort() != 0) {
                port = listen.getPort();
                _log.debug((Object)("Port set to " + port));
            }
            if (listen.getAddress() != null) {
                host = listen.getAddress();
                _log.debug((Object)("host set to " + host));
            }
            if (listen.getProto() != null) {
                proto = listen.getProto();
                _log.debug((Object)("Proto set to " + proto));
            }
            try {
                _log.debug((Object)("Trying to make a URL from " + proto + ", " + host + ", " + port + ", " + path));
                url = new URL(proto, host, port, path);
                BmxQuery query = new BmxQuery(url);
                query.getResult();
                return url;
            }
            catch (MalformedURLException e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return url;
    }

    private List<Listen> getListens(String installPath, String filename) {
        ArrayList<Listen> listens = new ArrayList<Listen>();
        List<String> config = VfwsServerDetector.parseConfigForListen(installPath, filename);
        Iterator<String> it = config.iterator();
        while (it.hasNext()) {
            Listen listen = new Listen(it.next());
            if (!listen.isValid()) continue;
            listens.add(listen);
        }
        return listens;
    }

    private String getInstallPath(Long pid) {
        String[] args = VfwsServerDetector.getProcArgs((long)pid);
        String last = null;
        for (int i = 0; i < args.length; ++i) {
            if (!ARG_ROOTDIR.equals(args[i])) continue;
            last = args[i + 1];
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> parseConfigForListen(String installPath, String filename) {
        File file = new File(installPath + "/" + filename);
        ArrayList<String> config = new ArrayList<String>();
        BufferedReader reader = null;
        if (!file.exists()) {
            _log.debug((Object)(file.getAbsolutePath() + " doesn't exist"));
            return config;
        }
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                List<String> includedConf;
                String[] ent;
                char chr;
                if (line.length() == 0 || (chr = line.charAt(0)) == '#' || chr == '<' || Character.isWhitespace(chr)) continue;
                int ix = line.indexOf(35);
                if (ix != -1) {
                    line = line.substring(0, ix);
                }
                if (CONF_DIRECTIVE_LISTEN.equals((ent = StringUtil.explodeQuoted((String)(line = line.trim())))[0].toUpperCase())) {
                    if (ent.length > 2) {
                        String value = "";
                        for (int i = 1; i < ent.length; ++i) {
                            if (null == ent[i]) continue;
                            value = value + " " + ent[i];
                        }
                        config.add(value);
                        continue;
                    }
                    config.add(ent[1]);
                    continue;
                }
                if (!CONF_DIRECTIVE_INCLUDE.equals(ent[0].toUpperCase()) || (includedConf = VfwsServerDetector.parseConfigForListen(installPath, ent[1])).isEmpty()) continue;
                config.addAll(includedConf);
            }
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return config;
    }

    private List<String> getPtqlQueries() {
        return _ptqlQueries;
    }

    static {
        _ptqlQueries.add("State.Name.eq=httpd.prefork,State.Name.Pne=$1");
        _ptqlQueries.add("State.Name.eq=httpd.worker,State.Name.Pne=$1");
        if (VfwsServerDetector.isWin32()) {
            _ptqlQueries.add("State.Name.eq=httpd");
        }
    }
}

