/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mysql_stats;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.sigar.FileInfo;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.StringConfigOption;

public class MySqlStatsLogTrackPlugin
extends LogFileTailPlugin {
    private static final String[] LOG_LEVELS = new String[0];
    private final Log _log = LogFactory.getLog(MySqlStatsLogTrackPlugin.class);
    private final Pattern TIME_REGEX = Pattern.compile(" Time: ");
    private final Pattern HASH_REGEX = Pattern.compile("^#");
    private static final String SLOW_LOG_FILE = "slow_query.file";
    private long _time = -1L;
    private final StringBuffer _lineBuf = new StringBuffer();
    private static final int MAX_LENGTH = 2000;

    public String[] getLogLevelAliases() {
        return LOG_LEVELS;
    }

    protected boolean supportsLogLevels() {
        return false;
    }

    protected ConfigOption getFilesOption(TypeInfo info, ConfigResponse config) {
        StringConfigOption option = new StringConfigOption(SLOW_LOG_FILE, "Slow Query Log File", config.getValue("installpath") + "/log/mysql_general.slow");
        option.setOptional(true);
        return option;
    }

    public String[] getFiles(ConfigResponse config) {
        return new String[]{config.getValue(SLOW_LOG_FILE)};
    }

    public TrackEvent processLine(FileInfo info, String line) {
        if (this.TIME_REGEX.matcher(line).find()) {
            this._time = this.getTime(line);
        }
        if (this._time == -1L) {
            this._time = System.currentTimeMillis();
        }
        this._lineBuf.append(line);
        if (this.HASH_REGEX.matcher(line).find()) {
            return null;
        }
        String log = this._lineBuf.length() > 2000 ? this._lineBuf.substring(0, 2000) : this._lineBuf.toString();
        this._lineBuf.setLength(0);
        return this.newTrackEvent(this._time, -1, info.getName(), log);
    }

    protected String getDefaultLogFile(TypeInfo info, ConfigResponse config) {
        String file = config.getValue(SLOW_LOG_FILE);
        if (file == null) {
            return "";
        }
        file = info.isWin32Platform() ? StringUtil.replace((String)file, (String)"/", (String)"\\") : StringUtil.replace((String)file, (String)"\\", (String)"/");
        return file;
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
    }

    private long getTime(String line) {
        String[] toks = line.split("\\s+");
        String dateBuf = toks[2];
        Calendar cal = Calendar.getInstance();
        cal.clear();
        char[] dateToks = dateBuf.toCharArray();
        int year = Integer.valueOf(dateToks[0] + "" + dateToks[1]);
        cal.set(1, year += 2000);
        int month = Integer.valueOf(dateToks[2] + "" + dateToks[3]);
        cal.set(2, --month);
        int day = Integer.valueOf(dateToks[4] + "" + dateToks[5]);
        cal.set(5, day);
        String timeBuf = toks[3];
        String[] timeToks = timeBuf.split(":");
        cal.set(11, Integer.parseInt(timeToks[0]));
        cal.set(12, Integer.parseInt(timeToks[1]));
        cal.set(13, Integer.parseInt(timeToks[2]));
        return cal.getTimeInMillis();
    }
}

