/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.rabbitmq.detect;

import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentCommand;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.autoinventory.agent.client.AICommandsUtils;
import org.hyperic.hq.plugin.rabbitmq.core.HypericRabbitAdmin;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitObject;
import org.hyperic.hq.plugin.rabbitmq.core.RabbitVirtualHost;
import org.hyperic.hq.plugin.rabbitmq.manage.RabbitTransientResourceManager;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RabbitServerDetector
extends ServerDetector
implements AutoServerDetector {
    private static final Log logger = LogFactory.getLog(RabbitServerDetector.class);
    private static final String PTQL_QUERY = "State.Name.re=[beam|erl],Args.*.eq=-sname";
    private static Map<String, String> signatures = new HashMap<String, String>();

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        logger.debug((Object)("[getServerResources] platformConfig=" + platformConfig));
        ArrayList<ServerResource> resources = new ArrayList<ServerResource>();
        long[] pids = RabbitServerDetector.getPids((String)PTQL_QUERY);
        logger.debug((Object)("[getServerResources] pids.length=" + pids.length));
        if (pids.length > 0) {
            ArrayList<String> nodes = new ArrayList<String>();
            for (long nodePid : pids) {
                String node;
                String signature;
                String new_signature;
                String[] nodeArgs = RabbitServerDetector.getProcArgs((long)nodePid);
                String nodePath = this.getNodePath(nodeArgs);
                String nodeName = this.getServerName(nodeArgs);
                if (nodePath == null || nodes.contains(nodePath)) continue;
                nodes.add(nodePath);
                ServerResource server = this.doCreateServerResource(nodeName, nodePath, nodePid, nodeArgs);
                if (server == null) continue;
                resources.add(server);
                if (logger.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder("Discovered ").append(server.getName()).append(" productConfig=").append(server.getProductConfig()).append(" customProps=").append(server.getCustomProperties());
                    logger.debug((Object)sb.toString());
                }
                if ((new_signature = this.generateSignature(server)).equalsIgnoreCase(signature = signatures.get(node = server.getProductConfig().getValue("node")))) continue;
                if (signature != null) {
                    this.runAutoDiscovery(server.getProductConfig());
                }
                signatures.put(node, new_signature);
            }
        }
        return resources;
    }

    public void runAutoDiscovery(ConfigResponse cf) {
        logger.debug((Object)"[runAutoDiscovery] >> start");
        try {
            AgentRemoteValue configARV = AICommandsUtils.createArgForRuntimeDiscoveryConfig((int)0, (int)0, (String)"RabbitMQ", null, (ConfigResponse)cf);
            logger.debug((Object)("[runAutoDiscovery] configARV=" + configARV));
            AgentCommand ac = new AgentCommand(1, 1, "autoinv:pushRuntimeDiscoveryConfig", configARV);
            AgentDaemon.getMainInstance().getCommandDispatcher().processRequest(ac, null, null);
            logger.debug((Object)"[runAutoDiscovery] << OK");
        }
        catch (Exception ex) {
            logger.debug((Object)("[runAutoDiscovery]" + ex.getMessage()), (Throwable)ex);
        }
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        logger.debug((Object)("[discoverServices] config=" + config));
        ArrayList<ServiceResource> serviceResources = new ArrayList<ServiceResource>();
        List<ServiceResource> rabbitResources = this.createRabbitResources(config);
        if (rabbitResources != null && rabbitResources.size() > 0) {
            serviceResources.addAll(rabbitResources);
            this.syncServices(config, rabbitResources);
        }
        return serviceResources;
    }

    private void syncServices(ConfigResponse serviceConfig, List<ServiceResource> rabbitResources) {
        boolean autoSync = serviceConfig.getValue("autosync", "false").equals("true");
        logger.debug((Object)("[syncServices] autoSync=" + autoSync + " " + rabbitResources.size() + " resources"));
        if (autoSync) {
            try {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)serviceConfig.toProperties());
                props.putAll((Map<?, ?>)this.getManager().getProperties());
                RabbitTransientResourceManager manager = new RabbitTransientResourceManager(props);
                manager.syncServices(rabbitResources);
            }
            catch (Throwable e) {
                logger.debug((Object)("Could not sync transient services: " + e.getMessage()), e);
            }
        }
    }

    public List<ServiceResource> createRabbitResources(ConfigResponse serviceConfig) throws PluginException {
        List<ServiceResource> rabbitResources = null;
        ArrayList<RabbitObject> rabbitObjectss = new ArrayList<RabbitObject>();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("[createRabbitResources] serviceConfig=" + serviceConfig));
        }
        String node = serviceConfig.getValue("node");
        boolean noDurable = serviceConfig.getValue("nodurable", "false").equals("true");
        HypericRabbitAdmin admin = new HypericRabbitAdmin(serviceConfig);
        try {
            rabbitObjectss.addAll(admin.getConnections());
        }
        catch (PluginException ex) {
            logger.debug((Object)("[createRabbitResources] error with Connections: " + ex.getMessage()), (Throwable)ex);
        }
        try {
            rabbitObjectss.addAll(admin.getChannels());
        }
        catch (PluginException ex) {
            logger.debug((Object)("[createRabbitResources] error with Channels: " + ex.getMessage()), (Throwable)ex);
        }
        try {
            List<RabbitVirtualHost> vhosts = admin.getVirtualHosts();
            for (RabbitVirtualHost vhost : vhosts) {
                try {
                    rabbitObjectss.addAll(admin.getQueues(vhost));
                }
                catch (PluginException ex) {
                    logger.debug((Object)("[createRabbitResources] error with Queues on " + vhost + ": " + ex.getMessage()), (Throwable)ex);
                }
                try {
                    rabbitObjectss.addAll(admin.getExchanges(vhost));
                }
                catch (PluginException ex) {
                    logger.debug((Object)("[createRabbitResources] error with Exchanges on " + vhost + ": " + ex.getMessage()), (Throwable)ex);
                }
            }
            rabbitObjectss.addAll(vhosts);
        }
        catch (PluginException ex) {
            logger.debug((Object)ex, (Throwable)ex);
        }
        rabbitResources = this.doCreateServiceResources(rabbitObjectss, node, noDurable);
        return rabbitResources;
    }

    private List<ServiceResource> doCreateServiceResources(List<RabbitObject> rabbitObjects, String node, boolean noDurable) {
        ArrayList<ServiceResource> serviceResources = null;
        if (rabbitObjects != null) {
            serviceResources = new ArrayList<ServiceResource>();
            for (RabbitObject obj : rabbitObjects) {
                if (!obj.isDurable() && !noDurable) continue;
                ServiceResource service = this.createServiceResource(obj.getServiceType());
                service.setName(node + " " + obj.getServiceName());
                this.setProductConfig(service, obj.getProductConfig());
                service.setCustomProperties(obj.getCustomProperties());
                service.setMeasurementConfig();
                serviceResources.add(service);
            }
        }
        return serviceResources;
    }

    private ServerResource doCreateServerResource(String nodeName, String nodePath, long nodePid, String[] nodeArgs) throws PluginException {
        logger.debug((Object)"doCreateServerResource");
        ServerResource node = this.createServerResource(nodePath);
        node.setIdentifier(nodePath);
        node.setName(RabbitServerDetector.getPlatformName() + " " + this.getTypeInfo().getName() + " Node " + nodeName);
        node.setDescription(this.getTypeInfo().getName() + " Node " + nodePid);
        ConfigResponse conf = new ConfigResponse();
        for (int n = 0; n < nodeArgs.length; ++n) {
            if (!nodeArgs[n].equalsIgnoreCase("-rabbit_mochiweb") || !nodeArgs[n + 1].equalsIgnoreCase("port")) continue;
            conf.setValue("port", nodeArgs[n + 2]);
        }
        conf.setValue("node", nodeName);
        this.populateListeningPorts(nodePid, conf, true);
        logger.debug((Object)("ProductConfig[" + conf + "]"));
        ConfigResponse log = this.createLogConfig(nodeArgs);
        if (log != null) {
            this.setMeasurementConfig(node, log);
        }
        this.setProductConfig(node, conf);
        return node;
    }

    private ConfigResponse createLogConfig(String[] nodeArgs) {
        Pattern p = Pattern.compile("[{]file,\\s*\"([^\"]+)\"}");
        ConfigResponse logConfig = null;
        for (int n = 0; n < nodeArgs.length; ++n) {
            File log;
            Matcher m;
            if (!nodeArgs[n].equalsIgnoreCase("-kernel") || !nodeArgs[n + 1].equalsIgnoreCase("error_logger") || !nodeArgs[n + 2].startsWith("{file,") || !(m = p.matcher(nodeArgs[n + 2])).find() || !(log = new File(m.group(1))).exists() || !log.canRead()) continue;
            logConfig = new ConfigResponse();
            logConfig.setValue("server.log_track.enable", true);
            logConfig.setValue("server.log_track.files", log.getAbsolutePath());
        }
        return logConfig;
    }

    private String getServerName(String[] args) {
        String name = null;
        for (int n = 0; n < args.length; ++n) {
            if (!args[n].equalsIgnoreCase("-sname")) continue;
            name = args[n + 1];
        }
        if (name != null && !name.contains("@")) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                String hostname = addr.getHostName();
                String old_name = name;
                name = name + "@" + hostname;
                name = name.substring(0, name.indexOf("."));
                logger.debug((Object)("-sname=" + old_name + " -> " + name));
            }
            catch (UnknownHostException ex) {
                name = null;
                logger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return name;
    }

    private String getNodePath(String[] args) {
        String mpath = null;
        for (int n = 0; n < args.length; ++n) {
            if (!args[n].equalsIgnoreCase("-mnesia") || !args[n + 1].equalsIgnoreCase("dir")) continue;
            mpath = args[n + 2];
            if (mpath.startsWith("\"")) {
                mpath = mpath.substring(1);
            }
            if (mpath.endsWith("\"")) {
                mpath = mpath.substring(0, mpath.length() - 1);
            }
            logger.debug((Object)("mnesia " + args[n] + " " + args[n + 1] + " " + args[n + 2]));
        }
        return mpath;
    }

    private String generateSignature(ServerResource server) {
        boolean disable = "true".equalsIgnoreCase(this.getManager().getProperty("rabbitmq.disable.runtimeScan"));
        logger.debug((Object)("[generateSignature] rabbitmq.disable.runtimeScan=" + disable));
        if (disable) {
            return "";
        }
        ArrayList<RabbitObject> objs = new ArrayList<RabbitObject>();
        try {
            HypericRabbitAdmin admin = new HypericRabbitAdmin(server.getProductConfig());
            objs.addAll(admin.getChannels());
            objs.addAll(admin.getConnections());
            List<RabbitVirtualHost> vhs = admin.getVirtualHosts();
            for (RabbitVirtualHost vh : vhs) {
                objs.addAll(admin.getQueues(vh));
                objs.addAll(admin.getExchanges(vh));
            }
        }
        catch (PluginException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            objs.clear();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (RabbitObject obj : objs) {
            names.add(obj.getServiceName());
        }
        Collections.sort(names);
        return ((Object)names).toString();
    }

    private void populateListeningPorts(long pid, ConfigResponse productConfig, boolean b) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class, Boolean.TYPE);
            plp.invoke(null, pid, productConfig, b);
        }
        catch (ClassNotFoundException ex) {
            logger.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            logger.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }
}

