/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere.jmx;

import com.ibm.websphere.management.AdminClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.websphere.jmx.WebSphereQuery;
import org.hyperic.hq.product.LogFileTrackPlugin;

public class AppServerQuery
extends WebSphereQuery {
    private static final Log log = LogFactory.getLog((String)AppServerQuery.class.getName());
    public static final String MBEAN_TYPE = "Server";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_JAVA_VERSION = "javaVersion";
    private static final String ATTR_JAVA_VENDOR = "javaVendor";
    private static final String[] VM_ATTRS = new String[]{"javaVersion", "javaVendor"};
    String installpath;

    public String getMBeanType() {
        return MBEAN_TYPE;
    }

    public String getMBeanAlias() {
        return "process";
    }

    public String getResourceName() {
        return this.getResourceType();
    }

    public String getResourceType() {
        return "WebSphere " + this.getVersion();
    }

    public String getPropertyName() {
        return "server.name";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getMetricProperties() {
        String addr = "<address xmi:id=\"EndPoint_1\"";
        String name = this.getName();
        String node = this.getParent().getName();
        String cell = this.getParent().getCell();
        File serverXML = new File(this.installpath + "/config/cells/" + cell + "/nodes/" + node + "/servers/" + name + "/server.xml");
        String port = "9080";
        log.debug((Object)("[getMetricProperties] xml=" + serverXML));
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(serverXML));
            while ((line = in.readLine()) != null) {
                if (line.indexOf("<address xmi:id=\"EndPoint_1\"") == -1) continue;
                int ix = line.indexOf("port=\"");
                if (ix != -1) {
                    line = line.substring(ix + 6);
                    ix = line.indexOf("\"");
                    port = line.substring(0, ix);
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        Properties props = super.getMetricProperties();
        props.setProperty("server.port", port);
        String[] logs = new String[]{"trace.log", "SystemErr.log", "SystemOut.log"};
        StringBuffer files = new StringBuffer();
        for (int i = 0; i < logs.length; ++i) {
            String logPath = "logs" + File.separator + this.getName() + File.separator + logs[i];
            if (!new File(this.installpath, logPath).exists()) continue;
            files.append(logPath);
            if (i + 1 == logs.length) continue;
            files.append(',');
        }
        props.setProperty(LogFileTrackPlugin.PROP_FILES_SERVER, files.toString());
        return props;
    }

    public WebSphereQuery cloneInstance() {
        WebSphereQuery query = super.cloneInstance();
        ((AppServerQuery)query).installpath = this.installpath;
        return query;
    }

    public boolean getAttributes(AdminClient mServer, ObjectName name) {
        String version = name.getKeyProperty(ATTR_VERSION);
        if (version != null) {
            this.attrs.put(ATTR_VERSION, version);
        }
        try {
            String[] vms = (String[])mServer.getAttribute(name, "javaVMs");
            if (vms != null) {
                this.getAttributes(mServer, new ObjectName(vms[0]), VM_ATTRS);
            }
            return super.getAttributes(mServer, name);
        }
        catch (Exception e) {
            log.error((Object)("Error getting JVM attributes for '" + name + "': " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public String[] getAttributeNames() {
        return new String[]{"pid", "cellName"};
    }
}

