/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WebsphereTraceLogParser {
    private DateFormat dateFormat = new SimpleDateFormat("M/d/yy hh:mm:ss:SSS z");

    Entry parse(String line) {
        if (line.length() == 0 || line.charAt(0) != '[') {
            return null;
        }
        Entry entry = new Entry();
        int ix = (line = line.substring(1)).indexOf(93);
        if (ix == -1) {
            return null;
        }
        String timestamp = line.substring(0, ix);
        entry.time = System.currentTimeMillis();
        if ((ix = (line = line.substring(ix + 1).trim()).indexOf(32)) == -1) {
            return null;
        }
        entry.thread = line.substring(0, ix);
        if ((ix = (line = line.substring(ix + 1).trim()).indexOf(32)) == -1) {
            return null;
        }
        entry.subsystem = line.substring(0, ix);
        if ((ix = (line = line.substring(ix + 1).trim()).indexOf(32)) == -1) {
            return null;
        }
        entry.level = line.substring(0, ix);
        entry.message = line = line.substring(ix + 1).trim();
        try {
            entry.time = this.dateFormat.parse(timestamp).getTime();
        }
        catch (ParseException e) {
            entry.time = System.currentTimeMillis();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        WebsphereTraceLogParser parser = new WebsphereTraceLogParser();
        block5: for (int i = 0; i < args.length; ++i) {
            File file = new File(args[i]);
            System.out.println(file);
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    try {
                        Entry entry = parser.parse(line);
                        if (entry == null) continue;
                        System.out.println(entry);
                    }
                    catch (Exception e) {
                        System.out.println("ERROR-->" + e.getMessage());
                        System.out.println("LINE='" + line + "'");
                        e.printStackTrace();
                        continue block5;
                    }
                }
                continue;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    class Entry {
        long time;
        String thread;
        String subsystem;
        String level;
        String message;

        Entry() {
        }

        public String toString() {
            return "[" + this.level + "] " + "[" + new Date(this.time) + "] " + this.message;
        }
    }
}

