/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.samba;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.sigar.FileInfo;

public class SambaErrorLogPlugin
extends LogFileTailPlugin {
    private static final Pattern fatal = Pattern.compile("fatal", 2);
    private static final Pattern failed = Pattern.compile("failed", 2);
    private static final Pattern error = Pattern.compile("error", 2);
    private static final Pattern beginLine = Pattern.compile("\\[\\d{4}\\/\\d{2}\\/\\d{2}");
    private static final String FATAL = "Fatal";
    private static final String ERROR = "Error";
    private static final String FAILED = "Failed";
    private static final String INFO = "Information";
    private static final String DEBUG = "Debug";
    private String myBegin = "";
    private static final String[] LOG_LEVELS = new String[]{"Fatal", "Error,Failed", "Information", "Debug"};

    public String[] getLogLevelAliases() {
        return LOG_LEVELS;
    }

    public TrackEvent processLine(FileInfo info, String line) {
        if (beginLine.matcher(line).find()) {
            this.myBegin = line;
            return null;
        }
        try {
            String msg = this.myBegin + line;
            this.myBegin = "";
            String[] toks = msg.split("\\s");
            long millis = this.getTimeMillis(toks[0].substring(1, toks[0].length()), toks[1].substring(0, toks[1].length() - 1));
            int logLevel = 0;
            try {
                logLevel = Integer.parseInt(toks[2].substring(0, 1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return this.newTrackEvent(millis, this.getErrorType(msg, logLevel), info.getName(), msg);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String getErrorType(String line, int logLevel) {
        if (logLevel > 0) {
            return DEBUG;
        }
        if (fatal.matcher(line).find()) {
            return FATAL;
        }
        if (failed.matcher(line).find()) {
            return FAILED;
        }
        if (error.matcher(line).find()) {
            return ERROR;
        }
        return INFO;
    }

    private long getTimeMillis(String date, String timeOfDay) throws NumberFormatException {
        Calendar rtn = Calendar.getInstance();
        rtn.clear();
        String[] dateToks = date.split("\\/");
        String[] timeToks = timeOfDay.split(":");
        if (dateToks.length != 3 || timeToks.length != 3) {
            return System.currentTimeMillis();
        }
        int month = Integer.parseInt(dateToks[0]);
        int day = Integer.parseInt(dateToks[1]);
        int year = Integer.parseInt(dateToks[2]);
        int hour = Integer.parseInt(timeToks[0]);
        int min = Integer.parseInt(timeToks[1]);
        int secs = Integer.parseInt(timeToks[2]);
        rtn.set(2, month - 1);
        rtn.set(5, day);
        rtn.set(1, year);
        rtn.set(11, hour);
        rtn.set(12, min);
        rtn.set(13, secs);
        return rtn.getTimeInMillis();
    }
}

