
#ifndef __EXTENSIONS_H__
#define __EXTENSIONS_H__


/*
 * In case we need to make extensions to this API for other modules to register
 * things with the SNMP-agent are for the SNMP agent to make info available
 * we must keep track of a API-version.
 * We also must now not rotate the currently defined items in the
 * 'covalent_snmp_sconfig' and the 'external_mib_subtree'.
 */

#define SNMPAGT_API_VERSION	1

typedef int (mib_init)(server_rec *s, apr_pool_t *p);
typedef int (covalent_snmp_logger_funtion_t)(snmpagent_log_record_t *data);

typedef struct {
    oid *base_oid;
    size_t base_oid_length;
    struct variables *variables;
    size_t variable_size;
    int variables_amount;
    mib_init *init;
    covalent_snmp_logger_funtion_t *logging_sink;
} external_mib_subtree_t;

int init_register_external_mibtree(apr_pool_t *p);
int external_mib_modules_init(server_rec *s, apr_pool_t *p);
int external_mib_modules_log_sinks(snmpagent_log_record_t *log_record);

int covalent_snmp_register_mibtree(server_rec *s, apr_pool_t *p, external_mib_subtree_t *mibinfo);
void covalent_snmp_notification(int specific, oid *enterprise,
                             int enterprise_length, struct variable_list *vars);

APR_DECLARE_OPTIONAL_FN(int, covalent_snmp_register_mibtree,
                             (server_rec *s, apr_pool_t *p, external_mib_subtree_t *mibinfo));
APR_DECLARE_OPTIONAL_FN(void, covalent_snmp_notification,
                             (int specific, oid *enterprise,
                             int enterprise_length, struct variable_list *vars));


#endif /* __EXTENSIONS_H__ */
