#ifndef __APACHE_SERVER_MIB_H__
#define __APACHE_SERVER_MIB_H__

typedef enum {
    ctApacheServerColdStart = 1,
    ctApacheServerWarmStart = 2,
    ctApacheServerShutdown = 3,
    ctApacheServerGracefullStart = 4
} CtApacheNotifications_t;

apr_time_t get_ctApacheStartTime(void);
unsigned long get_generation(void);
void send_ctApacheServerColdStart_trap(void);
void send_ctApacheServerWarmStart_trap(void);
void send_ctApacheServerShutdown_trap(void);

#ifdef COVALENT_APACHE_SERVER_BASIC_GROUP
void init_covalent_apache_server_table(void);
#else /* COVALENT_APACHE_SERVER_BASIC_GROUP */
#define init_covalent_apache_server_table()
#endif /* COVALENT_APACHE_SERVER_BASIC_GROUP */

#ifdef COVALENT_APACHE_SERVER_WWW_SERVICE_GROUP
void init_covalent_apache_server_www_service_table(void);
#else /* COVALENT_APACHE_SERVER_WWW_SERVICE_GROUP */
#define init_covalent_apache_server_www_service_table()
#endif /* COVALENT_APACHE_SERVER_WWW_SERVICE_GROUP */


#endif /* __APACHE_SERVER_MIB_H__ */
