/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.StatusResponse;
import org.hyperic.hq.hqapi1.types.User;
import org.hyperic.hq.hqapi1.types.UserResponse;
import org.hyperic.hq.hqapi1.types.UsersRequest;
import org.hyperic.hq.hqapi1.types.UsersResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserApi
extends BaseApi {
    UserApi(HQConnection connection) {
        super(connection);
    }

    public UserResponse getUser(String name) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("name", new String[]{name});
        return this.doGet("user/get.hqu", params, new XmlResponseHandler<UserResponse>(UserResponse.class));
    }

    public UserResponse getUser(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(id)});
        return this.doGet("user/get.hqu", params, new XmlResponseHandler<UserResponse>(UserResponse.class));
    }

    public UsersResponse getUsers() throws IOException {
        return this.doGet("user/list.hqu", new HashMap<String, String[]>(), new XmlResponseHandler<UsersResponse>(UsersResponse.class));
    }

    public UserResponse createUser(User user, String password) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("name", new String[]{user.getName()});
        params.put("password", new String[]{password});
        params.put("firstName", new String[]{user.getFirstName()});
        params.put("lastName", new String[]{user.getLastName()});
        params.put("emailAddress", new String[]{user.getEmailAddress()});
        params.put("active", new String[]{Boolean.toString(user.isActive())});
        params.put("department", new String[]{user.getDepartment()});
        params.put("htmlEmail", new String[]{Boolean.toString(user.isHtmlEmail())});
        params.put("SMSAddress", new String[]{user.getSMSAddress()});
        return this.doGet("user/create.hqu", params, new XmlResponseHandler<UserResponse>(UserResponse.class));
    }

    public StatusResponse deleteUser(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(id)});
        return this.doGet("user/delete.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse updateUser(User user) throws IOException {
        UsersRequest req = new UsersRequest();
        req.getUser().add(user);
        return this.doPost("user/sync.hqu", req, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse syncUsers(List<User> users) throws IOException {
        UsersRequest request = new UsersRequest();
        request.getUser().addAll(users);
        return this.doPost("user/sync.hqu", request, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse changePassword(User user, String password) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(user.getId())});
        params.put("password", new String[]{password});
        return this.doGet("user/changePassword.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }
}

