/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.Role;
import org.hyperic.hq.hqapi1.types.RoleRequest;
import org.hyperic.hq.hqapi1.types.RoleResponse;
import org.hyperic.hq.hqapi1.types.RolesRequest;
import org.hyperic.hq.hqapi1.types.RolesResponse;
import org.hyperic.hq.hqapi1.types.StatusResponse;
import org.hyperic.hq.hqapi1.types.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleApi
extends BaseApi {
    public RoleApi(HQConnection connection) {
        super(connection);
    }

    public RolesResponse getRoles() throws IOException {
        return this.doGet("role/list.hqu", new HashMap<String, String[]>(), new XmlResponseHandler<RolesResponse>(RolesResponse.class));
    }

    public RolesResponse getRoles(User u) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("user", new String[]{u.getName()});
        return this.doGet("role/list.hqu", params, new XmlResponseHandler<RolesResponse>(RolesResponse.class));
    }

    public RoleResponse getRole(String name) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("name", new String[]{name});
        return this.doGet("role/get.hqu", params, new XmlResponseHandler<RoleResponse>(RoleResponse.class));
    }

    public RoleResponse getRole(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{String.valueOf(id)});
        return this.doGet("role/get.hqu", params, new XmlResponseHandler<RoleResponse>(RoleResponse.class));
    }

    public RoleResponse createRole(Role role) throws IOException {
        RoleRequest request = new RoleRequest();
        request.setRole(role);
        return this.doPost("role/create.hqu", request, new XmlResponseHandler<RoleResponse>(RoleResponse.class));
    }

    public StatusResponse deleteRole(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{String.valueOf(id)});
        return this.doGet("role/delete.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse updateRole(Role role) throws IOException {
        RoleRequest request = new RoleRequest();
        request.setRole(role);
        return this.doPost("role/update.hqu", request, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse syncRoles(List<Role> roles) throws IOException {
        RolesRequest request = new RolesRequest();
        request.getRole().addAll(roles);
        return this.doPost("role/sync.hqu", request, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }
}

