/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.Group;
import org.hyperic.hq.hqapi1.types.GroupResponse;
import org.hyperic.hq.hqapi1.types.GroupsRequest;
import org.hyperic.hq.hqapi1.types.GroupsResponse;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.ResponseStatus;
import org.hyperic.hq.hqapi1.types.Role;
import org.hyperic.hq.hqapi1.types.StatusResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupApi
extends BaseApi {
    GroupApi(HQConnection conn) {
        super(conn);
    }

    public GroupResponse getGroup(String name) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("name", new String[]{name});
        return this.doGet("group/get.hqu", params, new XmlResponseHandler<GroupResponse>(GroupResponse.class));
    }

    public GroupResponse getGroup(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(id)});
        return this.doGet("group/get.hqu", params, new XmlResponseHandler<GroupResponse>(GroupResponse.class));
    }

    private GroupResponse syncSingleGroup(Group group) throws IOException {
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.add(group);
        GroupsResponse syncResponse = this.syncGroups(groups);
        GroupResponse groupResponse = new GroupResponse();
        groupResponse.setStatus(syncResponse.getStatus());
        if (syncResponse.getStatus().equals((Object)ResponseStatus.SUCCESS)) {
            groupResponse.setGroup(syncResponse.getGroup().get(0));
        } else {
            groupResponse.setError(syncResponse.getError());
        }
        return groupResponse;
    }

    public GroupResponse createGroup(Group group) throws IOException {
        return this.syncSingleGroup(group);
    }

    public GroupResponse updateGroup(Group group) throws IOException {
        return this.syncSingleGroup(group);
    }

    public StatusResponse deleteGroup(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(id)});
        return this.doGet("group/delete.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public GroupsResponse getGroups() throws IOException {
        return this.doGet("group/list.hqu", new HashMap<String, String[]>(), new XmlResponseHandler<GroupsResponse>(GroupsResponse.class));
    }

    public GroupsResponse getGroups(Role role) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("roleId", new String[]{role.getId().toString()});
        return this.doGet("group/list.hqu", params, new XmlResponseHandler<GroupsResponse>(GroupsResponse.class));
    }

    public GroupsResponse getCompatibleGroups() throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("compatible", new String[]{Boolean.toString(true)});
        return this.doGet("group/list.hqu", params, new XmlResponseHandler<GroupsResponse>(GroupsResponse.class));
    }

    public GroupsResponse getMixedGroups() throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("compatible", new String[]{Boolean.toString(false)});
        return this.doGet("group/list.hqu", params, new XmlResponseHandler<GroupsResponse>(GroupsResponse.class));
    }

    public GroupsResponse getGroupsContaining(Resource r) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("containing", new String[]{Boolean.toString(true)});
        params.put("resourceId", new String[]{Integer.toString(r.getId())});
        return this.doGet("group/list.hqu", params, new XmlResponseHandler<GroupsResponse>(GroupsResponse.class));
    }

    public GroupsResponse getGroupsNotContaining(Resource r) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("containing", new String[]{Boolean.toString(false)});
        params.put("resourceId", new String[]{Integer.toString(r.getId())});
        return this.doGet("group/list.hqu", params, new XmlResponseHandler<GroupsResponse>(GroupsResponse.class));
    }

    public GroupsResponse syncGroups(List<Group> groups) throws IOException {
        GroupsRequest groupRequest = new GroupsRequest();
        groupRequest.getGroup().addAll(groups);
        return this.doPost("group/sync.hqu", groupRequest, new XmlResponseHandler<GroupsResponse>(GroupsResponse.class));
    }
}

