/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.util.List;
import org.hyperic.hq.hqapi1.types.EscalationAction;
import org.hyperic.hq.hqapi1.types.Notify;
import org.hyperic.hq.hqapi1.types.Role;
import org.hyperic.hq.hqapi1.types.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EscalationActionBuilder {
    public static EscalationAction createEmailRolesAction(long wait, boolean sms, List<Role> roles) {
        EscalationAction a = new EscalationAction();
        a.setActionType(EscalationActionType.EMAIL.getType());
        a.setNotifyType(EscalationNotifyType.ROLES.getType());
        a.setWait(wait);
        a.setSms(sms);
        for (Role r : roles) {
            Notify n = new Notify();
            n.setName(r.getName());
            a.getNotify().add(n);
        }
        return a;
    }

    public static EscalationAction createEmailUsersAction(long wait, boolean sms, List<User> users) {
        EscalationAction a = new EscalationAction();
        a.setActionType(EscalationActionType.EMAIL.getType());
        a.setNotifyType(EscalationNotifyType.USERS.getType());
        a.setWait(wait);
        a.setSms(sms);
        for (User u : users) {
            Notify n = new Notify();
            n.setName(u.getName());
            a.getNotify().add(n);
        }
        return a;
    }

    public static EscalationAction createEmailAction(long wait, boolean sms, List<String> notify) {
        EscalationAction a = new EscalationAction();
        a.setActionType(EscalationActionType.EMAIL.getType());
        a.setNotifyType(EscalationNotifyType.EMAILS.getType());
        a.setWait(wait);
        a.setSms(sms);
        for (String email : notify) {
            Notify n = new Notify();
            n.setName(email);
            a.getNotify().add(n);
        }
        return a;
    }

    public static EscalationAction createSyslogAction(long wait, String meta, String product, String version) {
        EscalationAction a = new EscalationAction();
        a.setActionType(EscalationActionType.SYSLOG.getType());
        a.setWait(wait);
        a.setSyslogMeta(meta);
        a.setSyslogProduct(product);
        a.setSyslogVersion(version);
        return a;
    }

    public static EscalationAction createSnmpAction(long wait, String address, String notificationMechanism, String oid, String variableBindings) {
        EscalationAction a = new EscalationAction();
        a.setActionType(EscalationActionType.SNMP.getType());
        a.setWait(wait);
        a.setSnmpAddress(address);
        a.setSnmpNotificationMechanism(notificationMechanism);
        a.setSnmpOid(oid);
        a.setSnmpVariableBindings(variableBindings);
        return a;
    }

    public static EscalationAction createNoOpAction(long wait) {
        EscalationAction a = new EscalationAction();
        a.setActionType(EscalationActionType.NOOP.getType());
        a.setWait(wait);
        return a;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EscalationNotifyType {
        EMAILS("email"),
        USERS("users"),
        ROLES("roles");

        private final String _type;

        private EscalationNotifyType(String type) {
            this._type = type;
        }

        public String getType() {
            return this._type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EscalationActionType {
        EMAIL("EmailAction"),
        NOOP("NoOpAction"),
        SYSLOG("SyslogAction"),
        SNMP("SnmpAction");

        private final String _type;

        private EscalationActionType(String type) {
            this._type = type;
        }

        public String getType() {
            return this._type;
        }
    }
}

