/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.Agent;
import org.hyperic.hq.hqapi1.types.AgentBundleFilesResponse;
import org.hyperic.hq.hqapi1.types.AgentBundleNameResponse;
import org.hyperic.hq.hqapi1.types.AgentResponse;
import org.hyperic.hq.hqapi1.types.AgentsResponse;
import org.hyperic.hq.hqapi1.types.PingAgentResponse;
import org.hyperic.hq.hqapi1.types.StatusResponse;

public class AgentApi
extends BaseApi {
    public AgentApi(HQConnection connection) {
        super(connection);
    }

    public AgentResponse getAgent(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{String.valueOf(id)});
        return this.doGet("agent/get.hqu", params, new XmlResponseHandler<AgentResponse>(AgentResponse.class));
    }

    public AgentResponse getAgent(String agentToken) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("agentToken", new String[]{agentToken});
        return this.doGet("agent/get.hqu", params, new XmlResponseHandler<AgentResponse>(AgentResponse.class));
    }

    public AgentResponse getAgent(String address, int port) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("address", new String[]{address});
        params.put("port", new String[]{String.valueOf(port)});
        return this.doGet("agent/get.hqu", params, new XmlResponseHandler<AgentResponse>(AgentResponse.class));
    }

    public AgentsResponse getAgents() throws IOException {
        return this.doGet("agent/list.hqu", new HashMap<String, String[]>(), new XmlResponseHandler<AgentsResponse>(AgentsResponse.class));
    }

    public PingAgentResponse pingAgent(Agent agent) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{String.valueOf(agent.getId())});
        return this.doGet("agent/ping.hqu", params, new XmlResponseHandler<PingAgentResponse>(PingAgentResponse.class));
    }

    public StatusResponse transferPlugin(Agent agent, String plugin) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{String.valueOf(agent.getId())});
        params.put("plugin", new String[]{plugin});
        return this.doGet("agent/transferPlugin.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public AgentBundleFilesResponse bundleList() throws IOException {
        return this.doGet("agent/bundleList.hqu", new HashMap<String, String[]>(), new XmlResponseHandler<AgentBundleFilesResponse>(AgentBundleFilesResponse.class));
    }

    public AgentBundleNameResponse bundleStatus(Agent agent) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{String.valueOf(agent.getId())});
        return this.doGet("agent/bundleStatus.hqu", params, new XmlResponseHandler<AgentBundleNameResponse>(AgentBundleNameResponse.class));
    }

    public StatusResponse bundlePush(Agent agent, String bundle) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{String.valueOf(agent.getId())});
        params.put("bundle", new String[]{bundle});
        return this.doGet("agent/bundlePush.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }
}

