/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere.jmx;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.hyperic.hq.plugin.websphere.jmx.ModuleQuery;
import org.hyperic.hq.product.RtPlugin;

public class WebModuleQuery
extends ModuleQuery {
    public static final String MBEAN_TYPE = "WebModule";

    public String getMBeanType() {
        return MBEAN_TYPE;
    }

    public String getResourceType() {
        return "Webapp";
    }

    public String getPropertyName() {
        return "webapp";
    }

    public Properties getMetricProperties() {
        Properties props = super.getMetricProperties();
        props.setProperty("webapp.context", File.separator + this.getContextName());
        return props;
    }

    public String getContextName() {
        String ctxName = this.getName();
        if (ctxName.endsWith(".war")) {
            ctxName = ctxName.substring(0, ctxName.length() - 4);
        }
        return ctxName;
    }

    private String getRtLogDir() {
        try {
            String webXml = (String)this.getMBeanServer().invoke(this.getObjectName(), "getDeploymentDescriptor", new Object[0], new String[0]);
            return RtPlugin.getWebAppLogDir((InputStream)new ByteArrayInputStream(webXml.getBytes()));
        }
        catch (Exception e) {
            return null;
        }
    }
}

