/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.hyperic.hq.plugin.websphere.WebsphereUtil;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class WebsphereServiceMeasurementPlugin
extends MeasurementPlugin {
    private double doubleValue(Object obj) throws PluginException {
        try {
            return Double.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new PluginException("Cannot convert '" + obj + "' to double");
        }
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        String objectName = metric.getObjectName();
        String attribute = metric.getAttributeName();
        Object objectVal = null;
        try {
            ObjectName objName = new ObjectName(objectName);
            objectVal = WebsphereUtil.getMBeanServer(metric).getAttribute(objName, attribute);
        }
        catch (AttributeNotFoundException e) {
            if (metric.isAvail()) {
                objectVal = new Double(1.0);
            }
            throw new PluginException((Throwable)e);
        }
        catch (RuntimeException e) {
            if (metric.isAvail()) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof AttributeNotFoundException)) continue;
                    objectVal = new Double(1.0);
                    break;
                }
                if (objectVal == null) {
                    objectVal = new Double(0.0);
                }
            }
            throw e;
        }
        catch (Exception e) {
            if (metric.isAvail()) {
                objectVal = new Double(0.0);
            }
            throw new PluginException("Unable to obtain the value of metric: " + metric.getObjectName() + ".  Cause: " + e.getMessage());
        }
        String stringVal = objectVal.toString();
        String mappedVal = this.getTypeProperty(metric.getAttributeName() + "." + stringVal);
        double doubleVal = mappedVal != null ? this.doubleValue(mappedVal) : (objectVal instanceof Number ? ((Number)objectVal).doubleValue() : (objectVal instanceof Boolean ? ((Boolean)objectVal != false ? 1.0 : 0.0) : this.doubleValue(stringVal)));
        if (doubleVal == -1.0) {
            return new MetricValue(Double.NaN);
        }
        return new MetricValue(doubleVal);
    }

    public String translate(String template, ConfigResponse config) {
        return super.translate(template, config);
    }
}

