/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import com.ibm.websphere.management.AdminClient;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.JDBCConnectionPoolStats;
import javax.management.j2ee.statistics.JDBCStats;
import javax.management.j2ee.statistics.Stats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.websphere.WebsphereCollector;
import org.hyperic.hq.product.PluginException;

public class ConnectionPoolCollector
extends WebsphereCollector {
    private static final Log log = LogFactory.getLog((String)ConnectionPoolCollector.class.getName());
    private static final String[][] ATTRS = new String[][]{{"CreateCount", "numCreates"}, {"CloseCount", "numDestroys"}, {"PoolSize", "poolSize"}, {"FreePoolSize"}, {"WaitingThreadCount", "concurrentWaiters"}, {"AllocateCount", "numAllocates"}, {"ReturnCount", "numReturns"}, {"PrepStmtCacheDiscardCount", "prepStmtCacheDiscards"}, {"FaultCount", "faults"}, {"PercentUsed"}, {"PercentMaxed"}, {"UseTime"}, {"WaitTime"}, {"JDBCTime"}};

    protected ObjectName resolve(AdminClient server, ObjectName name) throws PluginException {
        Set beans;
        try {
            beans = server.queryNames(name, null);
        }
        catch (Exception e) {
            String msg = "resolve(" + name + "): " + e.getMessage();
            throw new PluginException(msg, (Throwable)e);
        }
        if (beans.size() != 1) {
            String msg = name + " query returned " + beans.size() + " results";
            throw new PluginException(msg);
        }
        return (ObjectName)beans.iterator().next();
    }

    protected void init(AdminClient mServer) throws PluginException {
        ObjectName name = this.newObjectNamePattern("type=JDBCProvider,j2eeType=JDBCResource,mbeanIdentifier=" + this.getModuleName() + "," + this.getProcessAttributes());
        this.setObjectName(this.resolve(mServer, name));
    }

    public void collect(AdminClient mServer) throws PluginException {
        JDBCStats stats = (JDBCStats)this.getStats(mServer, this.getObjectName());
        log.info((Object)("[collect] stats=" + (stats != null ? "OK" : "KO")));
        if (stats != null) {
            JDBCConnectionPoolStats[] pools = stats.getConnectionPools();
            log.info((Object)("[collect] pools.length=" + pools.length));
            for (int i = 0; i < pools.length; ++i) {
                JDBCConnectionPoolStats s = pools[i];
                log.info((Object)("[collect] s=" + s));
            }
            this.collectStatCount((Stats[])pools, ATTRS);
            this.setValue("npools", pools.length);
        } else {
            this.setValue("npools", 0.0);
        }
        this.setAvailability(true);
    }
}

