/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.rt.agent.server;

import com.hyperic.hq.rt.agent.commands.RtPlugin_args;
import com.hyperic.hq.rt.agent.server.RtSenderThread;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.RtPlugin;
import org.hyperic.hq.product.RtPluginManager;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.encoding.Base64;
import org.hyperic.util.schedule.EmptyScheduleException;
import org.hyperic.util.schedule.Schedule;
import org.hyperic.util.schedule.ScheduleException;
import org.hyperic.util.schedule.UnscheduledItemException;

class RtScheduleThread
implements Runnable {
    private static final int POLL_PERIOD = 60000;
    private static final String PARSED_FILE_KEY = "rt:alreadyparsed:";
    private Schedule schedule = new Schedule();
    private Hashtable serverIDs = new Hashtable();
    private volatile boolean shouldDie = false;
    private volatile Thread myThread = null;
    private Object interrupter = new Object();
    private AgentStorageProvider storage;
    private RtPluginManager manager;
    private Log log;
    private RtSenderThread sender;

    RtScheduleThread(RtSenderThread sender, RtPluginManager manager, AgentStorageProvider storage) throws AgentStartException {
        this.manager = manager;
        this.log = LogFactory.getLog(RtScheduleThread.class);
        this.sender = sender;
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptMe() {
        Object object = this.interrupter;
        synchronized (object) {
            this.interrupter.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unscheduleRt(String ident) throws UnscheduledItemException {
        Hashtable hashtable = this.serverIDs;
        synchronized (hashtable) {
            Long mID = (Long)this.serverIDs.get(ident);
            if (mID == null) {
                throw new UnscheduledItemException("Client Rt ID, '" + ident + "' was not " + "found");
            }
            try {
                this.schedule.unscheduleItem(mID.longValue());
            }
            catch (UnscheduledItemException exc) {
                throw new AgentAssertionException("Tried to unschedule something which wasn't scheduled");
            }
            this.serverIDs.remove(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleRt(RtPlugin_args args) {
        long oldNextTime;
        Integer svcID = args.getID();
        ConfigResponse config = null;
        long newNextTime = 0L;
        try {
            config = args.getConfigResponse();
        }
        catch (Exception e) {
            // empty catch block
        }
        Boolean endUser = args.getEndUser();
        long interval = endUser != false ? Long.parseLong(config.getValue(RtPlugin.CONFIG_EUINTERVAL)) : Long.parseLong(config.getValue(RtPlugin.CONFIG_INTERVAL));
        Hashtable hashtable = this.serverIDs;
        synchronized (hashtable) {
            long mID;
            try {
                oldNextTime = this.schedule.getTimeOfNext();
            }
            catch (EmptyScheduleException e) {
                oldNextTime = 0L;
            }
            String ident = svcID.toString() + endUser.toString();
            try {
                mID = this.schedule.scheduleItem((Object)args, interval * 1000L, true);
            }
            catch (ScheduleException e) {
                throw new AgentAssertionException(e.getMessage());
            }
            this.serverIDs.put(ident, new Long(mID));
            try {
                newNextTime = this.schedule.getTimeOfNext();
            }
            catch (EmptyScheduleException e) {
                throw new AgentAssertionException("Schedule should have at least one entry: " + e.getMessage());
            }
        }
        if (newNextTime < oldNextTime) {
            this.interruptMe();
        }
    }

    void die() {
        this.shouldDie = true;
        this.interruptMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.myThread = Thread.currentThread();
        while (!this.shouldDie) {
            List items;
            Object exc2;
            long timeToNext;
            Collection data = null;
            try {
                Hashtable hashtable = this.serverIDs;
                synchronized (hashtable) {
                    timeToNext = this.schedule.getTimeOfNext() - System.currentTimeMillis();
                }
            }
            catch (EmptyScheduleException exc2) {
                timeToNext = 60000L;
            }
            if (timeToNext > 0L) {
                this.log.debug((Object)("Sleeping " + timeToNext + " to next batch"));
                exc2 = this.interrupter;
                synchronized (exc2) {
                    try {
                        this.interrupter.wait(timeToNext);
                    }
                    catch (InterruptedException exc3) {
                        this.log.debug((Object)"Schedule thread kicked");
                    }
                }
            }
            exc2 = this.serverIDs;
            synchronized (exc2) {
                if (this.schedule.getNumItems() == 0) {
                    continue;
                }
                try {
                    items = this.schedule.consumeNextItems();
                }
                catch (EmptyScheduleException exc4) {
                    continue;
                }
            }
            for (int i = 0; i < items.size(); ++i) {
                RtPlugin_args scan = (RtPlugin_args)items.get(i);
                boolean success = false;
                try {
                    Properties alreadyParsed = this.readParsed(scan.getID());
                    boolean collectIPs = this.loadCollectIPs();
                    data = this.manager.getTimes(scan.getType(), scan.getConfigResponse(), scan.getID(), alreadyParsed, scan.getEndUser().booleanValue(), collectIPs);
                    this.writeParsed(scan.getID(), alreadyParsed);
                    success = true;
                }
                catch (PluginNotFoundException exc5) {
                    exc5.printStackTrace();
                }
                catch (Exception exc6) {
                    exc6.printStackTrace();
                }
                if (!success) continue;
                this.sender.processData(data);
            }
        }
    }

    private Properties readParsed(Integer serviceId) {
        String key = PARSED_FILE_KEY + serviceId;
        String serialized = this.storage.getValue(key);
        Properties alreadyParsed = new Properties();
        if (serialized == null) {
            this.log.warn((Object)("No previous log information for service id: " + serviceId));
            return alreadyParsed;
        }
        ByteArrayInputStream bIs = new ByteArrayInputStream(Base64.decode((String)serialized));
        try {
            alreadyParsed.load(bIs);
        }
        catch (IOException e) {
            this.log.error((Object)("Unable to load already parsed files: " + e.getMessage()));
        }
        return alreadyParsed;
    }

    private void writeParsed(Integer serviceId, Properties alreadyParsed) {
        String key = PARSED_FILE_KEY + serviceId;
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        try {
            alreadyParsed.store(bOs, null);
        }
        catch (IOException e) {
            this.log.error((Object)("Unable to store already parsed files: " + e.getMessage()));
        }
        String serialized = Base64.encode((byte[])bOs.toByteArray());
        this.storage.setValue(key, serialized);
    }

    private boolean loadCollectIPs() {
        String val = this.storage.getValue("Rt.Collect.IPs");
        if (val == null) {
            this.log.warn((Object)"Parsing RT data and COLLECTIPS setting was not set. Defaulting to true");
            return true;
        }
        return Boolean.valueOf(val);
    }
}

