/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.StringMatcher;
import org.hyperic.hq.product.jmx.MxObjectNameQuery;
import org.hyperic.hq.product.jmx.MxQuery;
import org.hyperic.hq.product.jmx.MxServiceQuery;

public class MxServerQuery
extends MxQuery {
    private static final Log log = LogFactory.getLog(MxServerQuery.class);
    private String installPath;
    private String version;
    private List services = new ArrayList();

    public MxServerQuery(ServerDetector detector) {
        this.setServerDetector(detector);
    }

    public List getServiceQueries() {
        return this.services;
    }

    public void findServices(MBeanServerConnection mServer) throws PluginException {
        Map servicePlugins = this.getServerDetector().getServiceInventoryPlugins();
        log.debug((Object)("[findServices] servicePlugins=" + servicePlugins));
        if (servicePlugins == null) {
            return;
        }
        for (Map.Entry entry : servicePlugins.entrySet()) {
            MxObjectNameQuery query;
            String type = (String)entry.getKey();
            String name = (String)entry.getValue();
            if (name == null) {
                query = new MxObjectNameQuery();
            } else {
                try {
                    Class<?> plugin = Class.forName(name);
                    query = (MxObjectNameQuery)plugin.newInstance();
                }
                catch (Exception e) {
                    log.error((Object)("Creating " + name + ": " + e), (Throwable)e);
                    continue;
                }
            }
            query.setType(type);
            query.setParent(this);
            try {
                this.findServices(mServer, query);
            }
            catch (IllegalArgumentException e) {
                String msg = "Error running query for " + type + ": " + e.getMessage();
                e.printStackTrace();
                System.out.println(msg);
            }
        }
    }

    private void findServices(MBeanServerConnection mServer, MxServiceQuery query) throws PluginException {
        Set<ObjectName> services;
        boolean isDebug = log.isDebugEnabled();
        query.initialize();
        String mbeanClass = query.getMBeanClass();
        String filter = query.getObjectNameFilter();
        StringMatcher matcher = null;
        if (filter != null) {
            matcher = new StringMatcher();
            if (filter.charAt(0) == '!') {
                matcher.setExcludes(filter.substring(1));
            } else {
                matcher.setIncludes(filter);
            }
        }
        try {
            ObjectName name = new ObjectName(query.getQueryName());
            log.debug((Object)("[findServices] name=" + name));
            services = mServer.queryNames(name, null);
            log.debug((Object)("[findServices] services=(" + services.size() + ")" + services));
        }
        catch (MalformedObjectNameException e) {
            String msg = query.getQueryName() + ": " + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
        catch (RemoteException e) {
            throw new PluginException("Cannot connect to server", e);
        }
        catch (IOException e) {
            throw new PluginException("Cannot connect to server", e);
        }
        for (ObjectName name : services) {
            block13: {
                if (matcher != null && !matcher.matches(name.toString())) {
                    if (!isDebug) continue;
                    log.debug((Object)("[" + name + "] !matches(" + matcher + ")"));
                    continue;
                }
                if (!query.apply(name)) continue;
                if (mbeanClass != null) {
                    try {
                        MBeanInfo info = mServer.getMBeanInfo(name);
                        if (!info.getClassName().matches(mbeanClass)) {
                            if (!isDebug) continue;
                            log.debug((Object)("[" + name + "] " + info.getClassName() + " !instanceof " + mbeanClass));
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        log.error((Object)("mServer.getMBeanInfo(" + name + "): " + e));
                    }
                    continue;
                }
            }
            MxServiceQuery service = query.cloneInstance();
            service.setObjectName(name);
            this.services.add(service);
            service.setParent(this);
            service.setServerQuery(this);
            service.getAttributes(mServer);
        }
    }

    public String getQualifiedName() {
        String name = ServerDetector.getPlatformName() + " " + this.getResourceType();
        if (this.getName() != null) {
            name = name + " " + this.getName();
        }
        return name;
    }

    public String getResourceType() {
        return this.getServerDetector().getTypeInfo().getName();
    }

    public String getIdentifier() {
        return this.getInstallPath();
    }

    public Properties getControlConfig() {
        Properties config = new Properties();
        return config;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public void setInstallPath(String installPath) {
        this.installPath = installPath;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

