/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import org.hyperic.hq.product.PlatformTypeInfo;
import org.hyperic.hq.product.TypeBuilder;
import org.hyperic.hq.product.TypeInfo;

public class ServerTypeInfo
extends TypeInfo
implements Cloneable {
    private String version;
    private String[] validPlatformTypes = TypeBuilder.ALL_PLATFORM_NAMES;
    private boolean isVirtual = false;

    public ServerTypeInfo() {
    }

    public ServerTypeInfo(String name, String description, String version) {
        this.setName(name);
        this.setDescription(description);
        this.version = version;
    }

    public Object clone() {
        ServerTypeInfo server = new ServerTypeInfo(this.getName(), this.getDescription(), this.getVersion());
        server.setValidPlatformTypes(this.getValidPlatformTypes());
        server.setVirtual(this.isVirtual());
        return server;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public int getType() {
        return 2;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String[] getValidPlatformTypes() {
        return this.validPlatformTypes;
    }

    public void setValidPlatformTypes(String[] validPlatformTypes) {
        this.validPlatformTypes = validPlatformTypes;
    }

    boolean isPlatformDevice() {
        String name = this.validPlatformTypes[0];
        return PlatformTypeInfo.isDevicePlatform(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Server(");
        sb.append("name=").append(this.getName()).append(", ");
        sb.append("version=").append(this.version).append(", ");
        sb.append("description=").append(this.getDescription()).append(", ");
        sb.append("platforms(");
        for (int i = 0; i < this.validPlatformTypes.length; ++i) {
            sb.append(this.validPlatformTypes[i]);
            if (i == this.validPlatformTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append("))");
        return sb.toString();
    }
}

