/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.HypericOperatingSystem;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.util.config.ConfigResponse;

public class PlatformDetector
extends GenericPlugin {
    public static final boolean IS_WIN32 = HypericOperatingSystem.IS_WIN32;
    public static final String[] UNIX_PLATFORM_NAMES = OperatingSystem.UNIX_NAMES;
    public static String[] WIN32_PLATFORM_NAMES = HypericOperatingSystem.WIN32_NAMES;
    public static final String[] PLATFORM_NAMES = HypericOperatingSystem.NAMES;

    public static boolean isSupportedPlatform(String name) {
        return HypericOperatingSystem.isSupported(name);
    }

    public static boolean isWin32(String name) {
        return HypericOperatingSystem.isWin32(name);
    }

    private String getValue(ConfigResponse config, String key) throws PluginException {
        String value = config.getValue(key);
        if (value == null) {
            throw new PluginException("Cannot detect platform with " + key + "=null");
        }
        return value;
    }

    public PlatformResource getPlatformResource(ConfigResponse config) throws PluginException {
        if (config == null) {
            throw new PluginException("Cannot detect platform with config=null");
        }
        String type = this.getValue(config, "platform.type");
        String fqdn = this.getValue(config, "platform.fqdn");
        String addr = this.getValue(config, "platform.ip");
        String name = config.getValue("platform.name");
        PlatformResource platform = new PlatformResource();
        platform.setFqdn(fqdn);
        platform.setPlatformTypeName(type);
        platform.setName(name);
        platform.setCpuCount(new Integer(1));
        platform.addInterface(addr, null, null);
        return platform;
    }
}

